package com.mediamain.android.view.webview.callback;

import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;

/**
 * Description:WebView接口监听返回
 * Date:2020/11/26 14:49
 *
 * @author Swilliam
 */

public interface FoxWebViewCallBackInterface {

    /**
     * 接收webView onPageStart中的回调信息
     *
     * @param webView 接收WebView
     * @param url     返回请求url
     */
    void onPageStarted(WebView webView, String url);

    /**
     * * 接收webView onPageFinish中的回调信息
     *
     * @param webView 接收WebView
     * @param url     返回请求url
     */
    void onPageFinished(WebView webView, String url);

    /**
     * * 接收webView onPageFinish中的回调信息
     *
     * @param webView 接收WebView
     * @param request 返回请求request
     * @param error   返回的错误信息
     */
    void pageReceiverError(WebView webView, WebResourceRequest request, WebResourceError error);

    /**
     * 接收webView shouldOverrideUrlLoading中的返回信息
     *
     * @param webView 接收WebView
     * @param url     返回请求url
     * @return shouldOverrideUrlLoading默认返回状态
     */
    boolean shouldOverrideUrlLoadingInterface(WebView webView, String url);

    /**
     * 接收webView onReceivedTitle中的返回信息
     *
     * @param webView 接收WebView
     * @param url     返回请求url
     */
    void onReceivedTitle(WebView webView, String url);

    /**
     * 接收webView onProgressChanged中的返回信息
     *
     * @param webView     接收WebView
     * @param newProgress 返回当前进度
     */
    void onProgressChanged(WebView webView, int newProgress);


    /**
     * shouldOverrideUrlLoading初始话行为
     *
     * @param webView 接收WebView
     * @param url     返回请求url
     */
    void shouldOverrideUrlLoadingInit(WebView webView, String url);

}
