package com.mediamain.android.view.webview.callback;

import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;

/**
 * Description:WebView基本数据配置接口
 * Author:Swilliam
 * Date:2020/11/27 14:20
 *
 * @author swilliam
 */

public abstract class FoxWebViewClientAndChromeClient implements FoxWebViewCallBackInterface {

    @Override
    public void onPageStarted(WebView webView, String url) {
    }

    @Override
    public void onReceivedTitle(WebView webView, String url) {
    }

    @Override
    public void onProgressChanged(WebView webView, int newProgress) {
    }

    @Override
    public void onPageFinished(WebView webView, String url) {
    }

    @Override
    public void pageReceiverError(WebView webView, WebResourceRequest request, WebResourceError error) {
    }

    @Deprecated
    @Override
    public boolean shouldOverrideUrlLoadingInterface(WebView webView, String url) {
        return shouldOverrideUrlLoading(webView, url);
    }

    @Override
    public void shouldOverrideUrlLoadingInit(WebView webView, String url) {
    }

    /**
     * 数据跳转的实现
     *
     * @param webView 需要加载的webview
     * @param url     加载地址
     * @return shouldOverrideUrlLoading默认接收的返回值
     * @date 2020/12/3 10:44
     */
    public abstract boolean shouldOverrideUrlLoading(WebView webView, String url);

}
