package com.mediamain.android.view.webview.helper;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.webkit.WebView;

import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.webview.broadcast.IntegrateWebViewBroadcast;

/**
 * Description:
 * Date:2020/11/27 15:06
 *
 * @author swilliam
 */

public class WebViewHelper {

    /**
     * 通用url跳转实现方案
     *
     * @param url          请求地址
     * @param webView      当前WebView
     * @param needDeepLink 是否需要支持deepLink功能
     * @return 返回shouldOverrideUrlLoading默认状态
     * @date 2020/11/27 16:28
     */
    public static boolean shouldOverrideUrlLoading(String url, WebView webView, boolean needDeepLink) {
        if (url == null) {
            return false;
        }
        if (url.startsWith(Constants.KEY_URL_HTTP) || url.startsWith(Constants.KEY_URL_HTTPS)) {
            //如果是8.0以上的,则不调用loadUrl,并返回false
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                return false;
            }
            if (webView != null) {
                webView.loadUrl(url);
            }
            return true;
        }
        if (!needDeepLink) {
            return true;
        }
        try {
            //防止找不到网页net:err_unknown_url_scheme,支持scheme协议
            boolean result = FoxBaseCommonUtils.startActivity(FoxBaseUtils.getApp(), Uri.parse(url));
            if (webView == null) {
                return true;
            }
            //通知前端开启页面成功与否
            String resultFunction = result ? "arouseAppSuccess()" : "arouseAppFail()";
            webView.loadUrl("JavaScript:" + resultFunction);
            return true;
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            //防止crash (如果手机上没有安装处理某个scheme开头的url的APP, 会导致crash)
            e.printStackTrace();
            return true;
        }
    }

    public static IntegrateWebViewBroadcast registerIntegrateBroadcast(@NonNull final WebView mWebView){
        IntegrateWebViewBroadcast broadcast = new IntegrateWebViewBroadcast(mWebView);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.mediamain.limited");
        intentFilter.addAction("com.mediamain.installed");
        mWebView.getContext().registerReceiver(broadcast, intentFilter);
        return broadcast;
    }

    public static void unregisterIntegrateBroadcast(@NonNull final WebView mWebView, IntegrateWebViewBroadcast broadcast){
        if (broadcast != null){
            mWebView.getContext().unregisterReceiver(broadcast);
        }
    }
}
