package com.mediamain.android.view.webview.jsbridge;

import android.app.Activity;
import android.content.Context;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import com.mediamain.android.base.download.IntegrateH5DownloadManager;
import com.mediamain.android.view.webview.broadcast.IntegrateWebViewBroadcast;
import com.mediamain.android.view.webview.helper.WebViewHelper;

/**
 * Description:
 *
 * @author:Swilliam
 * @date:2020/12/1 14:13
 */

public class DownloadJsBridgeHandler {

    private final Context mContext;
    private final WebView mWebView;
    private IntegrateWebViewBroadcast integrateWebViewBroadcast;

    /**
     * 设置初始化回调
     *
     * @param context 绑定context
     * @param webView 当前webView
     * @date 2020/12/2 14:13
     */
    public DownloadJsBridgeHandler(Context context, WebView webView) {
        mWebView = webView;
        mContext = context;

        init();
    }

    public DownloadJsBridgeHandler(Context mContext) {
        this(mContext, null);
    }

    private void init() {
        integrateWebViewBroadcast = WebViewHelper.registerIntegrateBroadcast(mWebView);
    }

    public void unregisterBroadcast() {
        WebViewHelper.unregisterIntegrateBroadcast(mWebView, integrateWebViewBroadcast);
    }

    /**
     * 主动下载/继续下载
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public void defaultDownload(final String url, final String packageName, final String icon, final String tuiaId) {
        if (mContext == null) {
            return;
        }
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                IntegrateH5DownloadManager.getInstance().defaultDownload(url, packageName, icon, tuiaId);
            }
        });
    }

    /**
     * 静默下载/继续下载
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public void backgroundDownload(final String url, final String packageName, final String tuiaId) {
        if (mContext == null) {
            return;
        }
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                IntegrateH5DownloadManager.getInstance().backgroundDownload(url, packageName, tuiaId);
            }
        });
    }

    /**
     * 暂停下载
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public void cancel(final String url, final String packageName, final String tuiaId) {
        if (mContext == null) {
            return;
        }
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                IntegrateH5DownloadManager.getInstance().cancel(url, packageName, tuiaId);
            }
        });
    }

    /**
     * 获取下载进度
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public int getProgress(final String url, final String packageName, final String tuiaId) {
        return (int) IntegrateH5DownloadManager.getInstance().getProgress(url, packageName, tuiaId);
    }

    /**
     * 安装应用
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public void installApp(final String url, final String packageName, final String icon, final String tuiaId) {
        if (mContext == null) {
            return;
        }
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                IntegrateH5DownloadManager.getInstance().installApp(url, packageName, icon, 0, tuiaId);
            }
        });
    }

    /**
     * 获取当前下载状态
     * -1：下载失败
     * 1：未下载
     * 2：正在下载
     * 3：已下载未安装
     * 4：已安装
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public int getDownloadStatus(final String url, final String packageName, final String tuiaId) {
        return IntegrateH5DownloadManager.getInstance().getDownloadStatus(url, packageName, tuiaId);
    }


    /**
     * 设置静默下载是否显示通知栏
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public void setShowNotification(final String url, final String packageName, final String icon, final boolean showNotification, final String tuiaId) {
        if (mContext == null) {
            return;
        }
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                IntegrateH5DownloadManager.getInstance().setShowNotification(url, packageName, icon, showNotification, tuiaId);
            }
        });
    }

    /**
     * 开启app
     *
     * @param url         下载链接
     * @param packageName 应用包名
     */
    @JavascriptInterface
    public void openApp(final String url, final String packageName, final String icon, final String tuiaId) {
        if (mContext == null) {
            return;
        }
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                IntegrateH5DownloadManager.getInstance().openApp(url, packageName, icon, 0, tuiaId);
            }
        });
    }


}
