package com.mediamain.android.view.webview.webviewchromeclient;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

import com.mediamain.android.R;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.view.webview.callback.FoxWebViewClientAndChromeClient;

/**
 * Description:
 * Author:Swilliam
 * Date:2020/11/26 14:50
 *
 * @author swilliam
 */

public class FoxWebViewChromeClient extends WebChromeClient {


    private final FoxWebViewClientAndChromeClient mFoxWebViewClientAndChromeClient;

    public FoxWebViewChromeClient(FoxWebViewClientAndChromeClient foxWebViewClientAndChromeClient) {
        mFoxWebViewClientAndChromeClient = foxWebViewClientAndChromeClient;
    }

    @Override
    public void onReceivedTitle(WebView view, String title) {
        super.onReceivedTitle(view, title);
        if (mFoxWebViewClientAndChromeClient != null) {
            mFoxWebViewClientAndChromeClient.onReceivedTitle(view, title);
        }
    }

    @Override
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        return super.onConsoleMessage(consoleMessage);
    }

    @Override
    public Bitmap getDefaultVideoPoster() {
        try {
            if (super.getDefaultVideoPoster() == null) {
                return BitmapFactory.decodeResource(FoxBaseSDK.getContext().getResources(),
                        R.drawable.icon_video);
            } else {
                return super.getDefaultVideoPoster();
            }
        } catch (Exception e) {
            return super.getDefaultVideoPoster();
        }
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        super.onProgressChanged(view, newProgress);
        if (mFoxWebViewClientAndChromeClient != null) {
            mFoxWebViewClientAndChromeClient.onProgressChanged(view, newProgress);
        }
    }


}
