package com.mediamain.android.view.webview.webviewclient;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.webview.callback.FoxWebViewClientAndChromeClient;

/**
 * Description:
 * Author:Swilliam
 * Date:2020/11/26 14:50
 *
 * @author swilliam
 */

public class FoxWebViewClient extends WebViewClient {

    private final FoxWebViewClientAndChromeClient mFoxWebViewClientAndChromeClient;

    public FoxWebViewClient(FoxWebViewClientAndChromeClient foxWebViewClientAndChromeClient) {
        mFoxWebViewClientAndChromeClient = foxWebViewClientAndChromeClient;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        FoxBaseLogUtils.d("onPageStarted url:" + url);
        if (mFoxWebViewClientAndChromeClient != null) {
            mFoxWebViewClientAndChromeClient.onPageStarted(view, url);
        }
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        FoxBaseLogUtils.d("onPageFinished url:" + url);
        if (mFoxWebViewClientAndChromeClient != null) {
            mFoxWebViewClientAndChromeClient.onPageFinished(view, url);
        }
    }

    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        FoxBaseLogUtils.d("onReceivedError:" + error.toString());
        if (mFoxWebViewClientAndChromeClient != null) {
            mFoxWebViewClientAndChromeClient.pageReceiverError(view, request, error);
        }
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        FoxBaseLogUtils.d("shouldOverrideUrlLoading url:" + url);
        try {
            if (mFoxWebViewClientAndChromeClient != null) {
                mFoxWebViewClientAndChromeClient.shouldOverrideUrlLoadingInit(view, url);
            }
            if (url == null) {
                return false;
            }
            //判断是否被jsbridge消费
            if (super.shouldOverrideUrlLoading(view, url)) {
                return true;
            }
            if (mFoxWebViewClientAndChromeClient != null) {
                return mFoxWebViewClientAndChromeClient.shouldOverrideUrlLoadingInterface(view, url);
            }
            return super.shouldOverrideUrlLoading(view, url);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        handler.proceed();
    }
}
