package com.mediamain.android.view.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ViewFlipper;

import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

/**
 * author: likaixuan
 * date: 2020/11/25
 * desc: ViewFlipper 兼容：onDetachedFromWindow 在onAttachedToWindow 之前调用，导致crash
 */
public class CompatViewFlipper extends ViewFlipper {
    public CompatViewFlipper(Context context) {
        super(context);
    }

    public CompatViewFlipper(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onDetachedFromWindow() {
        try {
            super.onDetachedFromWindow();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            FoxBaseLogUtils.e("ViewFlipper detach exception");
        }
    }
}
