package com.mediamain.android.view.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

/**
 * Created by ZSY on 2020-12-07.
 */

@SuppressLint("AppCompatCustomView")
public class FoxEditText extends EditText {

    private static java.lang.reflect.Field mParent;

    static {
        try {
            mParent = View.class.getDeclaredField("mParent");
            mParent.setAccessible(true);
        } catch (NoSuchFieldException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public FoxEditText(Context context) {
        super(context.getApplicationContext());
    }

    public FoxEditText(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
    }

    public FoxEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
    }


    @Override
    protected void onDetachedFromWindow() {
        try {
            if (mParent != null)
                mParent.set(this, null);
        } catch (IllegalAccessException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        super.onDetachedFromWindow();
    }
}
