/*
 * Decompiled with CFR 0.152.
 */
package com.mediamain.android.base.util;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresApi;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.a;
import com.mediamain.android.base.util.crash.b;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class FoxBaseLogUtils {
    public static ChangeQuickRedirect changeQuickRedirect;
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int A = 7;
    private static final char[] T;
    private static final int FILE = 16;
    private static final int JSON = 32;
    private static final int XML = 48;
    private static final String FILE_SEP;
    private static final String LINE_SEP;
    private static final String TOP_CORNER = "\u250c";
    private static final String MIDDLE_CORNER = "\u251c";
    private static final String LEFT_BORDER = "\u2502 ";
    private static final String BOTTOM_CORNER = "\u2514";
    private static final String SIDE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final int MAX_LEN = 1100;
    private static final String NOTHING = "log nothing";
    private static final String NULL = "null";
    private static final String ARGS = "args";
    private static final String PLACEHOLDER = " ";
    private static final Config CONFIG;
    private static SimpleDateFormat simpleDateFormat;
    private static final ExecutorService EXECUTOR;
    private static final SimpleArrayMap<Class, IFormatter> I_FORMATTER_MAP;

    private FoxBaseLogUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Config getConfig() {
        return CONFIG;
    }

    public static void v(Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1029, (Class[])new Class[]{Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(2, CONFIG.getGlobalTag(), objectArray);
    }

    public static void vTag(String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1030, (Class[])new Class[]{String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(2, string, objectArray);
    }

    public static void d(Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1031, (Class[])new Class[]{Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(3, CONFIG.getGlobalTag(), objectArray);
    }

    public static void dTag(String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1032, (Class[])new Class[]{String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(3, string, objectArray);
    }

    public static void i(Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1033, (Class[])new Class[]{Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(4, CONFIG.getGlobalTag(), objectArray);
    }

    public static void iTag(String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1034, (Class[])new Class[]{String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(4, string, objectArray);
    }

    public static void w(Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1035, (Class[])new Class[]{Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(5, CONFIG.getGlobalTag(), objectArray);
    }

    public static void wTag(String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1036, (Class[])new Class[]{String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(5, string, objectArray);
    }

    public static void e(Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1037, (Class[])new Class[]{Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(6, CONFIG.getGlobalTag(), objectArray);
    }

    public static void eTag(String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1038, (Class[])new Class[]{String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(6, string, objectArray);
    }

    public static void a(Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1039, (Class[])new Class[]{Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(7, CONFIG.getGlobalTag(), objectArray);
    }

    public static void aTag(String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1040, (Class[])new Class[]{String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(7, string, objectArray);
    }

    public static void file(Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1041, (Class[])new Class[]{Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(19, CONFIG.getGlobalTag(), object);
    }

    public static void file(int n2, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1042, (Class[])new Class[]{Integer.TYPE, Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(0x10 | n2, CONFIG.getGlobalTag(), object);
    }

    public static void file(String string, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1043, (Class[])new Class[]{String.class, Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(19, string, object);
    }

    public static void file(int n2, String string, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1044, (Class[])new Class[]{Integer.TYPE, String.class, Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(0x10 | n2, string, object);
    }

    public static void json(Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1045, (Class[])new Class[]{Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(35, CONFIG.getGlobalTag(), object);
    }

    public static void json(int n2, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1046, (Class[])new Class[]{Integer.TYPE, Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(0x20 | n2, CONFIG.getGlobalTag(), object);
    }

    public static void json(String string, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1047, (Class[])new Class[]{String.class, Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(35, string, object);
    }

    public static void json(int n2, String string, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1048, (Class[])new Class[]{Integer.TYPE, String.class, Object.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(0x20 | n2, string, object);
    }

    public static void xml(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1049, (Class[])new Class[]{String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(51, CONFIG.getGlobalTag(), string);
    }

    public static void xml(int n2, String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1050, (Class[])new Class[]{Integer.TYPE, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(0x30 | n2, CONFIG.getGlobalTag(), string);
    }

    public static void xml(String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1051, (Class[])new Class[]{String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(51, string, string2);
    }

    public static void xml(int n2, String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1052, (Class[])new Class[]{Integer.TYPE, String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        FoxBaseLogUtils.log(0x30 | n2, string, string2);
    }

    public static void log(int n2, String string, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1053, (Class[])new Class[]{Integer.TYPE, String.class, Object[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (!CONFIG.isLogSwitch()) {
            return;
        }
        final int n3 = n2 & 0xF;
        int n4 = n2 & 0xF0;
        if (CONFIG.isLog2ConsoleSwitch() || CONFIG.isLog2FileSwitch() || n4 == 16) {
            if (n3 < CONFIG.mConsoleFilter && n3 < CONFIG.mFileFilter) {
                return;
            }
            final TagHead tagHead = FoxBaseLogUtils.processTagAndHead(string);
            final String string2 = FoxBaseLogUtils.processBody(n4, objectArray);
            if (CONFIG.isLog2ConsoleSwitch() && n4 != 16 && n3 >= CONFIG.mConsoleFilter) {
                FoxBaseLogUtils.print2Console(n3, tagHead.tag, tagHead.consoleHead, string2);
            }
            if ((CONFIG.isLog2FileSwitch() || n4 == 16) && n3 >= CONFIG.mFileFilter) {
                EXECUTOR.execute(new Runnable(){
                    public static ChangeQuickRedirect changeQuickRedirect;

                    @Override
                    public void run() {
                        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1079, (Class[])new Class[0], Void.TYPE);
                        if (patchProxyResult.isSupported) {
                            return;
                        }
                        FoxBaseLogUtils.print2File(n3, tagHead.tag, tagHead.fileHead + string2);
                    }
                });
            }
        }
    }

    public static List<File> getLogFiles() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1054, (Class[])new Class[0], List.class);
        if (patchProxyResult.isSupported) {
            return (List)patchProxyResult.result;
        }
        String string = CONFIG.getDir();
        File file = new File(string);
        if (!file.exists()) {
            return new ArrayList<File>();
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){
            public static ChangeQuickRedirect changeQuickRedirect;

            @Override
            public boolean accept(File file, String string) {
                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{file, string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1080, (Class[])new Class[]{File.class, String.class}, Boolean.TYPE);
                if (patchProxyResult.isSupported) {
                    return (Boolean)patchProxyResult.result;
                }
                return FoxBaseLogUtils.isMatchLogFileName(string);
            }
        });
        ArrayList<File> arrayList = new ArrayList<File>();
        Collections.addAll(arrayList, fileArray);
        return arrayList;
    }

    private static TagHead processTagAndHead(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1055, (Class[])new Class[]{String.class}, TagHead.class);
        if (patchProxyResult.isSupported) {
            return (TagHead)patchProxyResult.result;
        }
        if (!CONFIG.mTagIsSpace && !CONFIG.isLogHeadSwitch()) {
            string = CONFIG.getGlobalTag();
        } else {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n2 = 3 + CONFIG.getStackOffset();
            if (n2 >= stackTraceElementArray.length) {
                StackTraceElement stackTraceElement = stackTraceElementArray[3];
                String string2 = FoxBaseLogUtils.getFileName(stackTraceElement);
                if (CONFIG.mTagIsSpace && FoxBaseLogUtils.isSpace(string)) {
                    int n3 = string2.indexOf(46);
                    string = n3 == -1 ? string2 : string2.substring(0, n3);
                }
                return new TagHead(string, null, ": ");
            }
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String string3 = FoxBaseLogUtils.getFileName(stackTraceElement);
            if (CONFIG.mTagIsSpace && FoxBaseLogUtils.isSpace(string)) {
                int n4 = string3.indexOf(46);
                String string4 = string = n4 == -1 ? string3 : string3.substring(0, n4);
            }
            if (CONFIG.isLogHeadSwitch()) {
                String string5 = Thread.currentThread().getName();
                String string6 = new Formatter().format("%s, %s.%s(%s:%d)", string5, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string3, stackTraceElement.getLineNumber()).toString();
                String string7 = " [" + string6 + "]: ";
                if (CONFIG.getStackDeep() <= 1) {
                    return new TagHead(string, new String[]{string6}, string7);
                }
                String[] stringArray = new String[Math.min(CONFIG.getStackDeep(), stackTraceElementArray.length - n2)];
                stringArray[0] = string6;
                int n5 = string5.length() + 2;
                String string8 = new Formatter().format("%" + n5 + "s", "").toString();
                int n6 = stringArray.length;
                for (int i2 = 1; i2 < n6; ++i2) {
                    stackTraceElement = stackTraceElementArray[i2 + n2];
                    stringArray[i2] = new Formatter().format("%s%s.%s(%s:%d)", string8, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), FoxBaseLogUtils.getFileName(stackTraceElement), stackTraceElement.getLineNumber()).toString();
                }
                return new TagHead(string, stringArray, string7);
            }
        }
        return new TagHead(string, null, ": ");
    }

    private static String getFileName(StackTraceElement stackTraceElement) {
        int n2;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{stackTraceElement}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1056, (Class[])new Class[]{StackTraceElement.class}, String.class);
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        String string = stackTraceElement.getFileName();
        if (string != null) {
            return string;
        }
        String string2 = stackTraceElement.getClassName();
        String[] stringArray = string2.split("\\.");
        if (stringArray.length > 0) {
            string2 = stringArray[stringArray.length - 1];
        }
        if ((n2 = string2.indexOf(36)) != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2 + ".java";
    }

    private static String processBody(int n2, Object ... objectArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), objectArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1057, (Class[])new Class[]{Integer.TYPE, Object[].class}, String.class);
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        String string = NULL;
        if (objectArray != null) {
            if (objectArray.length == 1) {
                string = FoxBaseLogUtils.formatObject(n2, objectArray[0]);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                int n3 = objectArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object = objectArray[i2];
                    stringBuilder.append(ARGS).append("[").append(i2).append("]").append(" = ").append(FoxBaseLogUtils.formatObject(object)).append(LINE_SEP);
                }
                string = stringBuilder.toString();
            }
        }
        return string.length() == 0 ? NOTHING : string;
    }

    private static String formatObject(int n2, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1058, (Class[])new Class[]{Integer.TYPE, Object.class}, String.class);
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        if (object == null) {
            return NULL;
        }
        if (n2 == 32) {
            return LogFormatter.object2String(object, 32);
        }
        if (n2 == 48) {
            return LogFormatter.object2String(object, 48);
        }
        return FoxBaseLogUtils.formatObject(object);
    }

    private static String formatObject(Object object) {
        IFormatter iFormatter;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1059, (Class[])new Class[]{Object.class}, String.class);
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        if (object == null) {
            return NULL;
        }
        if (!I_FORMATTER_MAP.isEmpty() && (iFormatter = (IFormatter)I_FORMATTER_MAP.get((Object)FoxBaseLogUtils.getClassFromObject(object))) != null) {
            return iFormatter.format(object);
        }
        return LogFormatter.object2String(object);
    }

    private static void print2Console(int n2, String string, String[] stringArray, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, stringArray, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1060, (Class[])new Class[]{Integer.TYPE, String.class, String[].class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (CONFIG.isSingleTagSwitch()) {
            FoxBaseLogUtils.printSingleTagMsg(n2, string, FoxBaseLogUtils.processSingleTagMsg(n2, string, stringArray, string2));
        } else {
            FoxBaseLogUtils.printBorder(n2, string, true);
            FoxBaseLogUtils.printHead(n2, string, stringArray);
            FoxBaseLogUtils.printMsg(n2, string, string2);
            FoxBaseLogUtils.printBorder(n2, string, false);
        }
    }

    private static void printBorder(int n2, String string, boolean bl) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, new Byte((byte)(bl ? 1 : 0))}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1061, (Class[])new Class[]{Integer.TYPE, String.class, Boolean.TYPE}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (CONFIG.isLogBorderSwitch()) {
            Log.println((int)n2, (String)string, (String)(bl ? TOP_BORDER : BOTTOM_BORDER));
        }
    }

    private static void printHead(int n2, String string, String[] stringArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, stringArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1062, (Class[])new Class[]{Integer.TYPE, String.class, String[].class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (stringArray != null) {
            for (String string2 : stringArray) {
                Log.println((int)n2, (String)string, (String)(CONFIG.isLogBorderSwitch() ? LEFT_BORDER + string2 : string2));
            }
            if (CONFIG.isLogBorderSwitch()) {
                Log.println((int)n2, (String)string, (String)MIDDLE_BORDER);
            }
        }
    }

    private static void printMsg(int n2, String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1063, (Class[])new Class[]{Integer.TYPE, String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        int n3 = string2.length();
        int n4 = n3 / 1100;
        if (n4 > 0) {
            int n5 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                FoxBaseLogUtils.printSubMsg(n2, string, string2.substring(n5, n5 + 1100));
                n5 += 1100;
            }
            if (n5 != n3) {
                FoxBaseLogUtils.printSubMsg(n2, string, string2.substring(n5, n3));
            }
        } else {
            FoxBaseLogUtils.printSubMsg(n2, string, string2);
        }
    }

    private static void printSubMsg(int n2, String string, String string2) {
        String[] stringArray;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1064, (Class[])new Class[]{Integer.TYPE, String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (!CONFIG.isLogBorderSwitch()) {
            Log.println((int)n2, (String)string, (String)string2);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray = string2.split(LINE_SEP)) {
            Log.println((int)n2, (String)string, (String)(LEFT_BORDER + string3));
        }
    }

    private static String processSingleTagMsg(int n2, String string, String[] stringArray, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, stringArray, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1065, (Class[])new Class[]{Integer.TYPE, String.class, String[].class, String.class}, String.class);
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (CONFIG.isLogBorderSwitch()) {
            stringBuilder.append(PLACEHOLDER).append(LINE_SEP);
            stringBuilder.append(TOP_BORDER).append(LINE_SEP);
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    stringBuilder.append(LEFT_BORDER).append(string3).append(LINE_SEP);
                }
                stringBuilder.append(MIDDLE_BORDER).append(LINE_SEP);
            }
            for (String string3 : string2.split(LINE_SEP)) {
                stringBuilder.append(LEFT_BORDER).append(string3).append(LINE_SEP);
            }
            stringBuilder.append(BOTTOM_BORDER);
        } else {
            if (stringArray != null) {
                stringBuilder.append(PLACEHOLDER).append(LINE_SEP);
                for (String string4 : stringArray) {
                    stringBuilder.append(string4).append(LINE_SEP);
                }
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static void printSingleTagMsg(int n2, String string, String string2) {
        int n3;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1066, (Class[])new Class[]{Integer.TYPE, String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        int n4 = string2.length();
        int n5 = n3 = CONFIG.isLogBorderSwitch() ? (n4 - BOTTOM_BORDER.length()) / 1100 : n4 / 1100;
        if (n3 > 0) {
            if (CONFIG.isLogBorderSwitch()) {
                Log.println((int)n2, (String)string, (String)(string2.substring(0, 1100) + LINE_SEP + BOTTOM_BORDER));
                int n6 = 1100;
                for (int i2 = 1; i2 < n3; ++i2) {
                    Log.println((int)n2, (String)string, (String)(PLACEHOLDER + LINE_SEP + TOP_BORDER + LINE_SEP + LEFT_BORDER + string2.substring(n6, n6 + 1100) + LINE_SEP + BOTTOM_BORDER));
                    n6 += 1100;
                }
                if (n6 != n4 - BOTTOM_BORDER.length()) {
                    Log.println((int)n2, (String)string, (String)(PLACEHOLDER + LINE_SEP + TOP_BORDER + LINE_SEP + LEFT_BORDER + string2.substring(n6, n4)));
                }
            } else {
                Log.println((int)n2, (String)string, (String)string2.substring(0, 1100));
                int n7 = 1100;
                for (int i3 = 1; i3 < n3; ++i3) {
                    Log.println((int)n2, (String)string, (String)(PLACEHOLDER + LINE_SEP + string2.substring(n7, n7 + 1100)));
                    n7 += 1100;
                }
                if (n7 != n4) {
                    Log.println((int)n2, (String)string, (String)(PLACEHOLDER + LINE_SEP + string2.substring(n7, n4)));
                }
            }
        } else {
            Log.println((int)n2, (String)string, (String)string2);
        }
    }

    private static void print2File(int n2, String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1067, (Class[])new Class[]{Integer.TYPE, String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        String string3 = FoxBaseLogUtils.getSdf().format(new Date());
        String string4 = string3.substring(0, 10);
        String string5 = string3.substring(11);
        String string6 = CONFIG.getDir() + CONFIG.getFilePrefix() + "_" + string4 + "_" + CONFIG.getProcessName() + CONFIG.getFileExtension();
        if (!FoxBaseLogUtils.createOrExistsFile(string6, string4)) {
            Log.e((String)"LogUtils", (String)("create " + string6 + " failed!"));
            return;
        }
        String string7 = string5 + T[n2 - 2] + "/" + string + string2 + LINE_SEP;
        FoxBaseLogUtils.input2File(string7, string6);
    }

    private static SimpleDateFormat getSdf() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1068, (Class[])new Class[0], SimpleDateFormat.class);
        if (patchProxyResult.isSupported) {
            return (SimpleDateFormat)patchProxyResult.result;
        }
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd HH:mm:ss.SSS ", Locale.getDefault());
        }
        return simpleDateFormat;
    }

    private static boolean createOrExistsFile(String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1069, (Class[])new Class[]{String.class, String.class}, Boolean.TYPE);
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        File file = new File(string);
        if (file.exists()) {
            return file.isFile();
        }
        if (!FoxBaseLogUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            FoxBaseLogUtils.deleteDueLogs(string, string2);
            boolean bl = file.createNewFile();
            if (bl) {
                FoxBaseLogUtils.printDeviceInfo(string, string2);
            }
            return bl;
        }
        catch (IOException iOException) {
            a.a(iOException);
            iOException.printStackTrace();
            return false;
        }
    }

    private static void deleteDueLogs(String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1070, (Class[])new Class[]{String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (CONFIG.getSaveDays() <= 0) {
            return;
        }
        File file = new File(string);
        File file2 = file.getParentFile();
        File[] fileArray = file2.listFiles(new FilenameFilter(){
            public static ChangeQuickRedirect changeQuickRedirect;

            @Override
            public boolean accept(File file, String string) {
                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{file, string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1081, (Class[])new Class[]{File.class, String.class}, Boolean.TYPE);
                if (patchProxyResult.isSupported) {
                    return (Boolean)patchProxyResult.result;
                }
                return FoxBaseLogUtils.isMatchLogFileName(string);
            }
        });
        if (fileArray == null || fileArray.length <= 0) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd", Locale.getDefault());
        try {
            long l2 = simpleDateFormat.parse(string2).getTime() - (long)CONFIG.getSaveDays() * 86400000L;
            for (final File file3 : fileArray) {
                String string3 = file3.getName();
                int n2 = string3.length();
                String string4 = FoxBaseLogUtils.findDate(string3);
                if (simpleDateFormat.parse(string4).getTime() > l2) continue;
                EXECUTOR.execute(new Runnable(){
                    public static ChangeQuickRedirect changeQuickRedirect;

                    @Override
                    public void run() {
                        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1082, (Class[])new Class[0], Void.TYPE);
                        if (patchProxyResult.isSupported) {
                            return;
                        }
                        boolean bl = file3.delete();
                        if (!bl) {
                            Log.e((String)"LogUtils", (String)("delete " + file3 + " failed!"));
                        }
                    }
                });
            }
        }
        catch (ParseException parseException) {
            a.a(parseException);
            parseException.printStackTrace();
        }
    }

    private static boolean isMatchLogFileName(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1071, (Class[])new Class[]{String.class}, Boolean.TYPE);
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return string.matches("^" + CONFIG.getFilePrefix() + "_[0-9]{4}_[0-9]{2}_[0-9]{2}_.*$");
    }

    private static String findDate(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1072, (Class[])new Class[]{String.class}, String.class);
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        Pattern pattern = Pattern.compile("[0-9]{4}_[0-9]{2}_[0-9]{2}");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static void printDeviceInfo(String string, String string2) {
        Object object;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1073, (Class[])new Class[]{String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        String string3 = "";
        int n2 = 0;
        try {
            object = FoxBaseUtils.a().getPackageManager().getPackageInfo(FoxBaseUtils.a().getPackageName(), 0);
            if (object != null) {
                string3 = object.versionName;
                n2 = object.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            a.a(nameNotFoundException);
            nameNotFoundException.printStackTrace();
        }
        object = "************* Log Head ****************\nDate of Log        : " + string2 + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + string3 + "\nApp VersionCode    : " + n2 + "\n************* Log Head ****************\n\n";
        FoxBaseLogUtils.input2File((String)object, string);
    }

    private static boolean createOrExistsDir(File file) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{file}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1074, (Class[])new Class[]{File.class}, Boolean.TYPE);
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1075, (Class[])new Class[]{String.class}, Boolean.TYPE);
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        if (string == null) {
            return true;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void input2File(String string, String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1076, (Class[])new Class[]{String.class, String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (CONFIG.mFileWriter == null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), "UTF-8"));
                bufferedWriter.write(string);
            }
            catch (IOException iOException) {
                a.a(iOException);
                iOException.printStackTrace();
                Log.e((String)"LogUtils", (String)("log to " + string2 + " failed!"));
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    a.a(iOException);
                    iOException.printStackTrace();
                }
            }
        } else {
            CONFIG.mFileWriter.write(string2, string);
        }
    }

    private static <T> Class getTypeClassFromParadigm(IFormatter<T> iFormatter) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iFormatter}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1077, (Class[])new Class[]{IFormatter.class}, Class.class);
        if (patchProxyResult.isSupported) {
            return (Class)patchProxyResult.result;
        }
        Type[] typeArray = iFormatter.getClass().getGenericInterfaces();
        Type type = typeArray.length == 1 ? typeArray[0] : iFormatter.getClass().getGenericSuperclass();
        type = ((ParameterizedType)type).getActualTypeArguments()[0];
        while (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        String string = type.toString();
        if (string.startsWith("class ")) {
            string = string.substring(6);
        } else if (string.startsWith("interface ")) {
            string = string.substring(10);
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.a(classNotFoundException);
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    private static Class getClassFromObject(Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1078, (Class[])new Class[]{Object.class}, Class.class);
        if (patchProxyResult.isSupported) {
            return (Class)patchProxyResult.result;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isAnonymousClass() || clazz.isSynthetic()) {
            String string;
            Type type;
            Type[] typeArray = clazz.getGenericInterfaces();
            if (typeArray.length == 1) {
                type = typeArray[0];
                while (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                string = type.toString();
            } else {
                type = clazz.getGenericSuperclass();
                while (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                string = type.toString();
            }
            if (string.startsWith("class ")) {
                string = string.substring(6);
            } else if (string.startsWith("interface ")) {
                string = string.substring(10);
            }
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                a.a(classNotFoundException);
                classNotFoundException.printStackTrace();
            }
        }
        return clazz;
    }

    static {
        T = new char[]{'V', 'D', 'I', 'W', 'E', 'A'};
        FILE_SEP = System.getProperty("file.separator");
        LINE_SEP = System.getProperty("line.separator");
        CONFIG = new Config();
        EXECUTOR = Executors.newSingleThreadExecutor();
        I_FORMATTER_MAP = new SimpleArrayMap();
    }

    private static final class LogFormatter {
        public static ChangeQuickRedirect changeQuickRedirect;
        private static final Gson GSON;

        private LogFormatter() {
        }

        static String object2String(Object object) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1094, (Class[])new Class[]{Object.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            return LogFormatter.object2String(object, -1);
        }

        static String object2String(Object object, int n2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object, new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1095, (Class[])new Class[]{Object.class, Integer.TYPE}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            if (object.getClass().isArray()) {
                return LogFormatter.array2String(object);
            }
            if (object instanceof Throwable) {
                return LogFormatter.throwable2String((Throwable)object);
            }
            if (object instanceof Bundle) {
                return LogFormatter.bundle2String((Bundle)object);
            }
            if (object instanceof Intent) {
                return LogFormatter.intent2String((Intent)object);
            }
            if (n2 == 32) {
                return LogFormatter.object2Json(object);
            }
            if (n2 == 48) {
                return LogFormatter.formatXml(object.toString());
            }
            return object.toString();
        }

        private static String throwable2String(Throwable throwable) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{throwable}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1096, (Class[])new Class[]{Throwable.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            return b.a(throwable, 3);
        }

        private static String bundle2String(Bundle bundle) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{bundle}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1097, (Class[])new Class[]{Bundle.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            Iterator iterator = bundle.keySet().iterator();
            if (!iterator.hasNext()) {
                return "Bundle {}";
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Bundle { ");
            while (true) {
                String string = (String)iterator.next();
                Object object = bundle.get(string);
                stringBuilder.append(string).append('=');
                if (object instanceof Bundle) {
                    stringBuilder.append(object == bundle ? "(this Bundle)" : LogFormatter.bundle2String((Bundle)object));
                } else {
                    stringBuilder.append(FoxBaseLogUtils.formatObject(object));
                }
                if (!iterator.hasNext()) {
                    return stringBuilder.append(" }").toString();
                }
                stringBuilder.append(',').append(' ');
            }
        }

        private static String intent2String(Intent intent) {
            Intent intent2;
            ClipData clipData;
            Rect rect;
            ComponentName componentName;
            String string;
            int n2;
            Uri uri;
            Object object;
            Set set;
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{intent}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1098, (Class[])new Class[]{Intent.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Intent { ");
            boolean bl = true;
            String string2 = intent.getAction();
            if (string2 != null) {
                stringBuilder.append("act=").append(string2);
                bl = false;
            }
            if ((set = intent.getCategories()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("cat=[");
                boolean bl2 = true;
                object = set.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (!bl2) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string3);
                    bl2 = false;
                }
                stringBuilder.append("]");
            }
            if ((uri = intent.getData()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("dat=").append(uri);
            }
            if ((object = intent.getType()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("typ=").append((String)object);
            }
            if ((n2 = intent.getFlags()) != 0) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("flg=0x").append(Integer.toHexString(n2));
            }
            if ((string = intent.getPackage()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("pkg=").append(string);
            }
            if ((componentName = intent.getComponent()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("cmp=").append(componentName.flattenToShortString());
            }
            if ((rect = intent.getSourceBounds()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("bnds=").append(rect.toShortString());
            }
            if (Build.VERSION.SDK_INT >= 16 && (clipData = intent.getClipData()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                LogFormatter.clipData2String(clipData, stringBuilder);
            }
            if ((clipData = intent.getExtras()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("extras={");
                stringBuilder.append(LogFormatter.bundle2String((Bundle)clipData));
                stringBuilder.append('}');
            }
            if (Build.VERSION.SDK_INT >= 15 && (intent2 = intent.getSelector()) != null) {
                if (!bl) {
                    stringBuilder.append(' ');
                }
                bl = false;
                stringBuilder.append("sel={");
                stringBuilder.append(intent2 == intent ? "(this Intent)" : LogFormatter.intent2String(intent2));
                stringBuilder.append("}");
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }

        @RequiresApi(api=16)
        private static void clipData2String(ClipData clipData, StringBuilder stringBuilder) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{clipData, stringBuilder}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1099, (Class[])new Class[]{ClipData.class, StringBuilder.class}, Void.TYPE);
            if (patchProxyResult.isSupported) {
                return;
            }
            ClipData.Item item = clipData.getItemAt(0);
            if (item == null) {
                stringBuilder.append("ClipData.Item {}");
                return;
            }
            stringBuilder.append("ClipData.Item { ");
            String string = item.getHtmlText();
            if (string != null) {
                stringBuilder.append("H:");
                stringBuilder.append(string);
                stringBuilder.append("}");
                return;
            }
            CharSequence charSequence = item.getText();
            if (charSequence != null) {
                stringBuilder.append("T:");
                stringBuilder.append(charSequence);
                stringBuilder.append("}");
                return;
            }
            Uri uri = item.getUri();
            if (uri != null) {
                stringBuilder.append("U:").append(uri);
                stringBuilder.append("}");
                return;
            }
            Intent intent = item.getIntent();
            if (intent != null) {
                stringBuilder.append("I:");
                stringBuilder.append(LogFormatter.intent2String(intent));
                stringBuilder.append("}");
                return;
            }
            stringBuilder.append("NULL");
            stringBuilder.append("}");
        }

        private static String object2Json(Object object) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1100, (Class[])new Class[]{Object.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            if (object instanceof CharSequence) {
                return LogFormatter.formatJson(object.toString());
            }
            try {
                return GSON.toJson(object);
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return object.toString();
            }
        }

        private static String formatJson(String string) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1101, (Class[])new Class[]{String.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            try {
                int n2 = string.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 == '{') {
                        return new JSONObject(string).toString(2);
                    }
                    if (c2 == '[') {
                        return new JSONArray(string).toString(2);
                    }
                    if (Character.isWhitespace(c2)) continue;
                    return string;
                }
            }
            catch (JSONException jSONException) {
                a.a(jSONException);
                jSONException.printStackTrace();
            }
            return string;
        }

        private static String formatXml(String string) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1102, (Class[])new Class[]{String.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            try {
                StreamSource streamSource = new StreamSource(new StringReader(string));
                StreamResult streamResult = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(streamSource, streamResult);
                string = streamResult.getWriter().toString().replaceFirst(">", ">" + LINE_SEP);
            }
            catch (Exception exception) {
                a.a(exception);
                exception.printStackTrace();
            }
            return string;
        }

        private static String array2String(Object object) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (int)1103, (Class[])new Class[]{Object.class}, String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            if (object instanceof Object[]) {
                return Arrays.deepToString((Object[])object);
            }
            if (object instanceof boolean[]) {
                return Arrays.toString((boolean[])object);
            }
            if (object instanceof byte[]) {
                return Arrays.toString((byte[])object);
            }
            if (object instanceof char[]) {
                return Arrays.toString((char[])object);
            }
            if (object instanceof double[]) {
                return Arrays.toString((double[])object);
            }
            if (object instanceof float[]) {
                return Arrays.toString((float[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            if (object instanceof long[]) {
                return Arrays.toString((long[])object);
            }
            if (object instanceof short[]) {
                return Arrays.toString((short[])object);
            }
            throw new IllegalArgumentException("Array has incompatible type: " + object.getClass());
        }

        static {
            GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        }
    }

    private static final class TagHead {
        String tag;
        String[] consoleHead;
        String fileHead;

        TagHead(String string, String[] stringArray, String string2) {
            this.tag = string;
            this.consoleHead = stringArray;
            this.fileHead = string2;
        }
    }

    public static interface IFileWriter {
        public void write(String var1, String var2);
    }

    public static abstract class IFormatter<T> {
        public static ChangeQuickRedirect changeQuickRedirect;

        public abstract String format(T var1);
    }

    public static final class Config {
        public static ChangeQuickRedirect changeQuickRedirect;
        private String mDefaultDir;
        private String mDir;
        private String mFilePrefix = "util";
        private String mFileExtension = ".txt";
        private boolean mLogSwitch = true;
        private boolean mLog2ConsoleSwitch = true;
        private String mGlobalTag = "TM_LOG";
        private boolean mTagIsSpace = true;
        private boolean mLogHeadSwitch = true;
        private boolean mLog2FileSwitch = false;
        private boolean mLogBorderSwitch = true;
        private boolean mSingleTagSwitch = true;
        private int mConsoleFilter = 2;
        private int mFileFilter = 2;
        private int mStackDeep = 1;
        private int mStackOffset = 0;
        private int mSaveDays = -1;
        private String mProcessName = FoxBaseUtils.e();
        private IFileWriter mFileWriter;

        private Config() {
            if (this.mDefaultDir != null) {
                return;
            }
            this.mDefaultDir = "mounted".equals(Environment.getExternalStorageState()) && FoxBaseUtils.a().getExternalCacheDir() != null ? FoxBaseUtils.a().getExternalCacheDir() + FILE_SEP + "log" + FILE_SEP : FoxBaseUtils.a().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        }

        public final Config setLogSwitch(boolean bl) {
            this.mLogSwitch = bl;
            return this;
        }

        public final Config setConsoleSwitch(boolean bl) {
            this.mLog2ConsoleSwitch = bl;
            return this;
        }

        public final Config setGlobalTag(String string) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1083, (Class[])new Class[]{String.class}, Config.class);
            if (patchProxyResult.isSupported) {
                return (Config)patchProxyResult.result;
            }
            if (FoxBaseLogUtils.isSpace(string)) {
                this.mGlobalTag = "";
                this.mTagIsSpace = true;
            } else {
                this.mGlobalTag = string;
                this.mTagIsSpace = false;
            }
            return this;
        }

        public final Config setLogHeadSwitch(boolean bl) {
            this.mLogHeadSwitch = bl;
            return this;
        }

        public final Config setLog2FileSwitch(boolean bl) {
            this.mLog2FileSwitch = bl;
            return this;
        }

        public final Config setDir(String string) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1084, (Class[])new Class[]{String.class}, Config.class);
            if (patchProxyResult.isSupported) {
                return (Config)patchProxyResult.result;
            }
            this.mDir = FoxBaseLogUtils.isSpace(string) ? null : (string.endsWith(FILE_SEP) ? string : string + FILE_SEP);
            return this;
        }

        public final Config setDir(File file) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{file}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1085, (Class[])new Class[]{File.class}, Config.class);
            if (patchProxyResult.isSupported) {
                return (Config)patchProxyResult.result;
            }
            this.mDir = file == null ? null : file.getAbsolutePath() + FILE_SEP;
            return this;
        }

        public final Config setFilePrefix(String string) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1086, (Class[])new Class[]{String.class}, Config.class);
            if (patchProxyResult.isSupported) {
                return (Config)patchProxyResult.result;
            }
            this.mFilePrefix = FoxBaseLogUtils.isSpace(string) ? "util" : string;
            return this;
        }

        public final Config setFileExtension(String string) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1087, (Class[])new Class[]{String.class}, Config.class);
            if (patchProxyResult.isSupported) {
                return (Config)patchProxyResult.result;
            }
            this.mFileExtension = FoxBaseLogUtils.isSpace(string) ? ".txt" : (string.startsWith(".") ? string : "." + string);
            return this;
        }

        public final Config setBorderSwitch(boolean bl) {
            this.mLogBorderSwitch = bl;
            return this;
        }

        public final Config setSingleTagSwitch(boolean bl) {
            this.mSingleTagSwitch = bl;
            return this;
        }

        public final Config setConsoleFilter(int n2) {
            this.mConsoleFilter = n2;
            return this;
        }

        public final Config setFileFilter(int n2) {
            this.mFileFilter = n2;
            return this;
        }

        public final Config setStackDeep(@IntRange(from=1L) int n2) {
            this.mStackDeep = n2;
            return this;
        }

        public final Config setStackOffset(@IntRange(from=0L) int n2) {
            this.mStackOffset = n2;
            return this;
        }

        public final Config setSaveDays(@IntRange(from=1L) int n2) {
            this.mSaveDays = n2;
            return this;
        }

        public final <T> Config addFormatter(IFormatter<T> iFormatter) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iFormatter}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1088, (Class[])new Class[]{IFormatter.class}, Config.class);
            if (patchProxyResult.isSupported) {
                return (Config)patchProxyResult.result;
            }
            if (iFormatter != null) {
                I_FORMATTER_MAP.put((Object)FoxBaseLogUtils.getTypeClassFromParadigm(iFormatter), iFormatter);
            }
            return this;
        }

        public final Config setFileWriter(IFileWriter iFileWriter) {
            this.mFileWriter = iFileWriter;
            return this;
        }

        public final String getProcessName() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1089, (Class[])new Class[0], String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            if (this.mProcessName == null) {
                return "";
            }
            return this.mProcessName.replace(":", "_");
        }

        public final String getDefaultDir() {
            return this.mDefaultDir;
        }

        public final String getDir() {
            return this.mDir == null ? this.mDefaultDir : this.mDir;
        }

        public final String getFilePrefix() {
            return this.mFilePrefix;
        }

        public final String getFileExtension() {
            return this.mFileExtension;
        }

        public final boolean isLogSwitch() {
            return this.mLogSwitch;
        }

        public final boolean isLog2ConsoleSwitch() {
            return this.mLog2ConsoleSwitch;
        }

        public final String getGlobalTag() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1090, (Class[])new Class[0], String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            if (FoxBaseLogUtils.isSpace(this.mGlobalTag)) {
                return "";
            }
            return this.mGlobalTag;
        }

        public final boolean isLogHeadSwitch() {
            return this.mLogHeadSwitch;
        }

        public final boolean isLog2FileSwitch() {
            return this.mLog2FileSwitch;
        }

        public final boolean isLogBorderSwitch() {
            return this.mLogBorderSwitch;
        }

        public final boolean isSingleTagSwitch() {
            return this.mSingleTagSwitch;
        }

        public final char getConsoleFilter() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1091, (Class[])new Class[0], Character.TYPE);
            if (patchProxyResult.isSupported) {
                return ((Character)patchProxyResult.result).charValue();
            }
            return T[this.mConsoleFilter - 2];
        }

        public final char getFileFilter() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1092, (Class[])new Class[0], Character.TYPE);
            if (patchProxyResult.isSupported) {
                return ((Character)patchProxyResult.result).charValue();
            }
            return T[this.mFileFilter - 2];
        }

        public final int getStackDeep() {
            return this.mStackDeep;
        }

        public final int getStackOffset() {
            return this.mStackOffset;
        }

        public final int getSaveDays() {
            return this.mSaveDays;
        }

        public String toString() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1093, (Class[])new Class[0], String.class);
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            return "process: " + this.getProcessName() + LINE_SEP + "switch: " + this.isLogSwitch() + LINE_SEP + "console: " + this.isLog2ConsoleSwitch() + LINE_SEP + "tag: " + this.getGlobalTag() + LINE_SEP + "head: " + this.isLogHeadSwitch() + LINE_SEP + "file: " + this.isLog2FileSwitch() + LINE_SEP + "dir: " + this.getDir() + LINE_SEP + "filePrefix: " + this.getFilePrefix() + LINE_SEP + "border: " + this.isLogBorderSwitch() + LINE_SEP + "singleTag: " + this.isSingleTagSwitch() + LINE_SEP + "consoleFilter: " + this.getConsoleFilter() + LINE_SEP + "fileFilter: " + this.getFileFilter() + LINE_SEP + "stackDeep: " + this.getStackDeep() + LINE_SEP + "stackOffset: " + this.getStackOffset() + LINE_SEP + "saveDays: " + this.getSaveDays() + LINE_SEP + "formatter: " + I_FORMATTER_MAP;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TYPE {
    }
}

