/*
 * Decompiled with CFR 0.152.
 */
package com.mediamain.android.nativead.jsbridge;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.WebView;
import com.mediamain.android.base.util.crash.a;
import com.mediamain.android.nativead.jsbridge.BridgeHandler;
import com.mediamain.android.nativead.jsbridge.BridgeUtil;
import com.mediamain.android.nativead.jsbridge.BridgeWebViewClient;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import com.mediamain.android.nativead.jsbridge.DefaultHandler;
import com.mediamain.android.nativead.jsbridge.Message;
import com.mediamain.android.nativead.jsbridge.WebViewJavascriptBridge;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class BridgeWebView
extends WebView
implements WebViewJavascriptBridge {
    public static ChangeQuickRedirect changeQuickRedirect;
    private final String TAG = "BridgeWebView";
    public static final String toLoadJs = "FoxWebViewJavascriptBridge.js";
    Map<String, CallBackFunction> responseCallbacks = new HashMap<String, CallBackFunction>();
    Map<String, BridgeHandler> messageHandlers = new HashMap<String, BridgeHandler>();
    BridgeHandler defaultHandler = new DefaultHandler();
    private List<Message> startupMessage = new ArrayList<Message>();
    private long uniqueId = 0L;

    public List<Message> getStartupMessage() {
        return this.startupMessage;
    }

    public void setStartupMessage(List<Message> list) {
        this.startupMessage = list;
    }

    public BridgeWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public BridgeWebView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init();
    }

    public BridgeWebView(Context context) {
        super(context);
        this.init();
    }

    public void setDefaultHandler(BridgeHandler bridgeHandler) {
        this.defaultHandler = bridgeHandler;
    }

    private void init() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1872, (Class[])new Class[0], Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        try {
            this.setVerticalScrollBarEnabled(false);
            this.setHorizontalScrollBarEnabled(false);
            this.getSettings().setJavaScriptEnabled(true);
            if (Build.VERSION.SDK_INT >= 19) {
                // empty if block
            }
            this.setWebViewClient(this.generateBridgeWebViewClient());
        }
        catch (Exception exception) {
            a.a(exception);
        }
    }

    public BridgeWebViewClient generateBridgeWebViewClient() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1873, (Class[])new Class[0], BridgeWebViewClient.class);
        if (patchProxyResult.isSupported) {
            return (BridgeWebViewClient)((Object)patchProxyResult.result);
        }
        return new BridgeWebViewClient(this);
    }

    void handlerReturnData(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1874, (Class[])new Class[]{String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        String string2 = BridgeUtil.getFunctionFromReturnUrl(string);
        CallBackFunction callBackFunction = this.responseCallbacks.get(string2);
        String string3 = BridgeUtil.getDataFromReturnUrl(string);
        if (callBackFunction != null) {
            callBackFunction.onCallBack(string3);
            this.responseCallbacks.remove(string2);
            return;
        }
    }

    @Override
    public void send(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1875, (Class[])new Class[]{String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        this.send(string, null);
    }

    @Override
    public void send(String string, CallBackFunction callBackFunction) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, callBackFunction}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1876, (Class[])new Class[]{String.class, CallBackFunction.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        this.doSend(null, string, callBackFunction);
    }

    private void doSend(String string, String string2, CallBackFunction callBackFunction) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2, callBackFunction}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1877, (Class[])new Class[]{String.class, String.class, CallBackFunction.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        Message message = new Message();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            message.setData(string2);
        }
        if (callBackFunction != null) {
            String string3 = String.format("JAVA_CB_%s", ++this.uniqueId + "_" + SystemClock.currentThreadTimeMillis());
            this.responseCallbacks.put(string3, callBackFunction);
            message.setCallbackId(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            message.setHandlerName(string);
        }
        this.queueMessage(message);
    }

    private void queueMessage(Message message) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{message}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1878, (Class[])new Class[]{Message.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (this.startupMessage != null) {
            this.startupMessage.add(message);
        } else {
            this.dispatchMessage(message);
        }
    }

    void dispatchMessage(Message message) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{message}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1879, (Class[])new Class[]{Message.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        String string = message.toJson();
        string = string.replaceAll("(\\\\)([^utrn])", "\\\\\\\\$1$2");
        string = string.replaceAll("(?<=[^\\\\])(\")", "\\\\\"");
        string = string.replaceAll("(?<=[^\\\\])(')", "\\\\'");
        string = string.replaceAll("%7B", URLEncoder.encode("%7B"));
        string = string.replaceAll("%7D", URLEncoder.encode("%7D"));
        string = string.replaceAll("%22", URLEncoder.encode("%22"));
        String string2 = String.format("javascript:WebViewJavascriptBridge._handleMessageFromNative('%s');", string);
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl(string2);
        }
    }

    void flushMessageQueue() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1880, (Class[])new Class[0], Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl("javascript:WebViewJavascriptBridge._fetchQueue();", new CallBackFunction(){
                public static ChangeQuickRedirect changeQuickRedirect;

                @Override
                public void onCallBack(String string) {
                    PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1885, (Class[])new Class[]{String.class}, Void.TYPE);
                    if (patchProxyResult.isSupported) {
                        return;
                    }
                    List<Message> list = null;
                    try {
                        list = Message.toArrayList(string);
                    }
                    catch (Exception exception) {
                        a.a(exception);
                        exception.printStackTrace();
                        return;
                    }
                    if (list == null || list.size() == 0) {
                        return;
                    }
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        String string2;
                        CallBackFunction callBackFunction;
                        Message message = list.get(i2);
                        String string3 = message.getResponseId();
                        if (!TextUtils.isEmpty((CharSequence)string3)) {
                            callBackFunction = BridgeWebView.this.responseCallbacks.get(string3);
                            string2 = message.getResponseData();
                            callBackFunction.onCallBack(string2);
                            BridgeWebView.this.responseCallbacks.remove(string3);
                            continue;
                        }
                        callBackFunction = null;
                        string2 = message.getCallbackId();
                        callBackFunction = !TextUtils.isEmpty((CharSequence)string2) ? new CallBackFunction(){
                            public static ChangeQuickRedirect changeQuickRedirect;

                            @Override
                            public void onCallBack(String string) {
                                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1886, (Class[])new Class[]{String.class}, Void.TYPE);
                                if (patchProxyResult.isSupported) {
                                    return;
                                }
                                Message message = new Message();
                                message.setResponseId(string2);
                                message.setResponseData(string);
                                BridgeWebView.this.queueMessage(message);
                            }
                        } : new CallBackFunction(){
                            public static ChangeQuickRedirect changeQuickRedirect;

                            @Override
                            public void onCallBack(String string) {
                            }
                        };
                        BridgeHandler bridgeHandler = !TextUtils.isEmpty((CharSequence)message.getHandlerName()) ? BridgeWebView.this.messageHandlers.get(message.getHandlerName()) : BridgeWebView.this.defaultHandler;
                        if (bridgeHandler == null) continue;
                        bridgeHandler.handler(message.getData(), callBackFunction);
                    }
                }
            });
        }
    }

    public void loadUrl(String string, CallBackFunction callBackFunction) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, callBackFunction}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1881, (Class[])new Class[]{String.class, CallBackFunction.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        this.loadUrl(string);
        this.responseCallbacks.put(BridgeUtil.parseFunctionName(string), callBackFunction);
    }

    public void registerHandler(String string, BridgeHandler bridgeHandler) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, bridgeHandler}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1882, (Class[])new Class[]{String.class, BridgeHandler.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (bridgeHandler != null) {
            this.messageHandlers.put(string, bridgeHandler);
        }
    }

    public void unregisterHandler(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1883, (Class[])new Class[]{String.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        if (string != null) {
            this.messageHandlers.remove(string);
        }
    }

    public void callHandler(String string, String string2, CallBackFunction callBackFunction) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, string2, callBackFunction}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (int)1884, (Class[])new Class[]{String.class, String.class, CallBackFunction.class}, Void.TYPE);
        if (patchProxyResult.isSupported) {
            return;
        }
        this.doSend(string, string2, callBackFunction);
    }
}

