/*
 * Decompiled with CFR 0.152.
 */
package cn.code.boxes.credits.sdk.core;

import cn.code.boxes.credits.sdk.annotation.OpField;
import cn.code.boxes.credits.sdk.exception.SupplierOpException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParameterChecker {
    public static void check(Object obj) {
        if (obj == null) {
            return;
        }
        List<Field> fields = ParameterChecker.getAllField(obj.getClass());
        if (fields == null || fields.size() == 0) {
            return;
        }
        for (Field field : fields) {
            OpField opAnnotation = field.getAnnotation(OpField.class);
            if (opAnnotation == null || !opAnnotation.required()) continue;
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null) {
                throw new SupplierOpException(SupplierOpException.Code.PARAMETER_REQUIRED_CHECK_ERROR, "field name -> " + field.getName());
            }
            ParameterChecker.check(value);
        }
    }

    private static List<Field> getAllField(Class<?> clazz) {
        Field[] fields;
        List<Field> superFields;
        if (clazz == null) {
            return null;
        }
        ArrayList<Field> ret = new ArrayList<Field>();
        if (clazz.getSuperclass() != null && (superFields = ParameterChecker.getAllField(clazz.getSuperclass())) != null && superFields.size() > 0) {
            ret.addAll(superFields);
        }
        if ((fields = clazz.getDeclaredFields()).length == 0) {
            return null;
        }
        ret.addAll(Arrays.asList(fields));
        return ret;
    }
}

