/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.kse;

import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.tls.kse.CertBean;
import cfca.sadk.tls.kse.PasswordTool;
import cfca.sadk.tls.sun.security.ssl.JSSEProvider;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.validator.GMCertificateException;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.util.Args;
import cfca.sadk.tls.util.Loggings;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeystoreUtils {
    public static final KeystoreUtils INSTANCE = new KeystoreUtils();
    private final Provider provider = new BouncyCastleProvider();
    private final Provider jsse = JSSEProvider.INSTANCE;

    private KeystoreUtils() {
    }

    private Certificate certFrom(byte[] certBytes) throws Exception {
        CertificateFactory fact = JSSEJCE.getCertificateFactory();
        return fact.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    private String hashImprint(byte[] encoding) {
        byte[] imprint = new byte[32];
        SM3Digest digest = new SM3Digest();
        if (encoding != null) {
            digest.update(encoding, 0, encoding.length);
        }
        digest.doFinal(imprint, 0);
        return Base64.toBase64String((byte[])imprint);
    }

    public SSLContext buildSSLContext(CertBean bean) throws Exception {
        TrustManager[] trustManagers = this.buildTrustManager(bean);
        KeyManager[] keyManagers = this.buildKeyManager(bean);
        SSLContext context = SSLContext.getInstance("GMTLSv1.1", this.jsse);
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public SSLContext buildSSLContext(String certBeanFile) throws Exception {
        return this.buildSSLContext(new CertBean(certBeanFile));
    }

    public TrustManager[] buildTrustManager(CertBean bean) throws Exception {
        TrustManagerFactory tmFactory = this.buildTrustManagerFactory(bean);
        return tmFactory == null ? null : tmFactory.getTrustManagers();
    }

    public TrustManager[] buildTrustManager(String certsFilePath) throws Exception {
        TrustManagerFactory tmFactory = this.buildTrustManagerFactory(certsFilePath);
        return tmFactory == null ? null : tmFactory.getTrustManagers();
    }

    public TrustManager[] buildTrustManager(X509Cert[] cacerts) throws Exception {
        TrustManagerFactory tmFactory = this.buildTrustManagerFactory(cacerts);
        return tmFactory == null ? null : tmFactory.getTrustManagers();
    }

    public TrustManagerFactory buildTrustManagerFactory(CertBean bean) throws Exception {
        if (bean == null) {
            throw new Exception("certBean=null");
        }
        return this.buildTrustManagerFactory(bean.getTrustsFilePath());
    }

    public TrustManagerFactory buildTrustManagerFactory(String certsFilePath) throws Exception {
        File file = new File(Args.notEmpty(certsFilePath, "certsFilePath"));
        if (!file.exists()) {
            throw new Exception("file not found certsFilePath=" + certsFilePath);
        }
        if (!file.isFile()) {
            throw new Exception("not file certsFilePath=" + certsFilePath);
        }
        String postfix = file.getName().toLowerCase();
        X509Cert[] cacerts = null;
        if (postfix.endsWith(".cer") || postfix.endsWith(".der")) {
            cacerts = new X509Cert[]{new X509Cert(certsFilePath)};
        } else if (postfix.endsWith(".p7b")) {
            cacerts = CertUtil.parseP7B((String)certsFilePath);
        } else {
            throw new Exception("do not support certsFilePath=" + certsFilePath);
        }
        return this.buildTrustManagerFactory(cacerts);
    }

    public TrustManagerFactory buildTrustManagerFactory(X509Cert[] cacerts) throws Exception {
        if (cacerts == null || cacerts.length == 0) {
            throw new Exception("cacerts==null/length==0");
        }
        KeyStore keystore = KeyStore.getInstance("BKS", this.provider);
        keystore.load(null, null);
        byte[] encoding = null;
        String alias = null;
        for (int i = 0; i < cacerts.length; ++i) {
            if (cacerts[i] == null) continue;
            encoding = cacerts[i].getEncoded();
            alias = this.hashImprint(encoding);
            keystore.setCertificateEntry(alias, this.certFrom(encoding));
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("GMTX509", this.jsse);
        trustManagerFactory.init(keystore);
        return trustManagerFactory;
    }

    public KeyManager[] buildKeyManager(CertBean bean) throws Exception {
        KeyManagerFactory kmFactory = this.buildKeyManagerFactory(bean);
        return kmFactory == null ? null : kmFactory.getKeyManagers();
    }

    public KeyManager[] buildKeyManager(String scerPath, String scerPass, String ecerPath, String ecerPass) throws Exception {
        KeyManagerFactory kmFactory = this.buildKeyManagerFactory(scerPath, scerPass, ecerPath, ecerPass);
        return kmFactory == null ? null : kmFactory.getKeyManagers();
    }

    public KeyManager[] buildKeyManager(PrivateKey sm2Skey, X509Cert sm2Scer, PrivateKey sm2Ekey, X509Cert sm2Ecer) throws Exception {
        KeyManagerFactory kmFactory = this.buildKeyManagerFactory(sm2Skey, sm2Scer, sm2Ekey, sm2Ecer);
        return kmFactory == null ? null : kmFactory.getKeyManagers();
    }

    public KeyManagerFactory buildKeyManagerFactory(CertBean bean) throws Exception {
        if (bean == null) {
            throw new Exception("certBean=null");
        }
        return this.buildKeyManagerFactory(bean.getSigSM2FilePath(), bean.getSigSM2FilePass(), bean.getEncSM2FilePath(), bean.getEncSM2FilePass());
    }

    public KeyManagerFactory buildKeyManagerFactory(String scerPath, String scerPass, String ecerPath, String ecerPass) throws Exception {
        KeyManagerFactory keyManagers = null;
        if (scerPath != null) {
            if (scerPass == null) {
                throw new Exception("scerPass==null");
            }
            if (ecerPath == null || ecerPass == null) {
                throw new Exception("ecerPath==null/ecerPass==null");
            }
            SM2PrivateKey sm2Skey = KeyUtil.getPrivateKeyFromSM2((String)scerPath, (String)PasswordTool.restored(scerPass, "scerPass"));
            SM2PrivateKey sm2Ekey = KeyUtil.getPrivateKeyFromSM2((String)ecerPath, (String)PasswordTool.restored(ecerPass, "ecerPass"));
            X509Cert sm2Scer = CertUtil.getCertFromSM2((String)scerPath);
            try {
                TLSValidator.validate(sm2Scer);
            }
            catch (GMCertificateException e) {
                Loggings.ERROR.error("signer cert check failed", (Throwable)e);
                throw e;
            }
            X509Cert sm2Ecer = CertUtil.getCertFromSM2((String)ecerPath);
            try {
                TLSValidator.validate(sm2Ecer);
            }
            catch (GMCertificateException e) {
                Loggings.ERROR.error("cipher cert check failed", (Throwable)e);
                throw e;
            }
            keyManagers = this.buildKeyManagerFactory((PrivateKey)sm2Skey, sm2Scer, (PrivateKey)sm2Ekey, sm2Ecer);
        }
        return keyManagers;
    }

    public KeyManagerFactory buildKeyManagerFactory(PrivateKey sm2Skey, X509Cert sm2Scer, PrivateKey sm2Ekey, X509Cert sm2Ecer) throws Exception {
        if (sm2Skey == null || sm2Scer == null) {
            throw new Exception("sm2Skey==null/sm2Scer==null");
        }
        if (sm2Ekey == null || sm2Ecer == null) {
            throw new Exception("sm2Ekey==null/sm2Ecer==null");
        }
        char[] password = Base64.toBase64String((byte[])SecureRandoms.getInstance().genBytes(12)).toCharArray();
        KeyFactory keyFatory = KeyFactory.getInstance("SM2", this.provider);
        PrivateKey sKey = keyFatory.generatePrivate(new PKCS8EncodedKeySpec(sm2Skey.getEncoded()));
        PrivateKey eKey = keyFatory.generatePrivate(new PKCS8EncodedKeySpec(sm2Ekey.getEncoded()));
        byte[] scoding = sm2Scer.getEncoding();
        byte[] ecoding = sm2Ecer.getEncoding();
        String sigAltName = String.format("GMSSLSN%s-%s@signer", sm2Scer.getStringSerialNumber(), this.hashImprint(scoding));
        String encAltName = String.format("GMSSLSN%s-%s@cipher", sm2Ecer.getStringSerialNumber(), this.hashImprint(ecoding));
        Certificate[] schain = new Certificate[]{this.certFrom(scoding)};
        Certificate[] echain = new Certificate[]{this.certFrom(ecoding)};
        KeyStore keystore = KeyStore.getInstance("BKS", this.provider);
        keystore.load(null, null);
        keystore.setKeyEntry(sigAltName, sKey, password, schain);
        keystore.setKeyEntry(encAltName, eKey, password, echain);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("GMTX509", this.jsse);
        keyManagerFactory.init(keystore, password);
        return keyManagerFactory;
    }
}

