/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.IAsymEncrypt;
import cfca.sadk.tls.pure.impl.SM2Helper;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import cfca.sadk.tls.util.Loggings;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2Encrypt
implements IAsymEncrypt {
    private static final Mechanism SM2 = new Mechanism("SM2");
    public static final IAsymEncrypt INSTANCE = new SM2Encrypt();

    @Override
    public byte[] encrypt(PublicKey encryptionKey, byte[] data) throws CryptoException {
        GMTKey sm2Key = SM2Helper.form(encryptionKey);
        byte[] defaultZ = sm2Key.getDefaultZ();
        try {
            Session session = CryptoFactory.singleton().session();
            byte[] encoded = session.encrypt(SM2, (Key)((SM2PublicKey)sm2Key), data);
            return this.format(encoded);
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(512);
            builder.append("SM2Encrypt failed");
            builder.append("\n encryptionKey: ").append(Hex.toHexString((byte[])defaultZ));
            builder.append("\n data: ").append(Debugger.dump(data));
            Loggings.ERROR.error(builder.toString());
            throw new CryptoException("encrypt failed", e);
        }
    }

    @Override
    public byte[] decrypt(PrivateKey decryptionKey, byte[] data) throws CryptoException {
        GMTKey sm2Key = SM2Helper.form(decryptionKey);
        byte[] defaultZ = sm2Key.getDefaultZ();
        try {
            Session session = CryptoFactory.singleton().session();
            return session.decrypt(SM2, (Key)((SM2PrivateKey)sm2Key), data);
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(512);
            builder.append("SM2Decrypt failed");
            builder.append("\n encryptionKey: ").append(Hex.toHexString((byte[])defaultZ));
            builder.append("\n data: ").append(Debugger.dump(data));
            Loggings.ERROR.error(builder.toString());
            throw new CryptoException("decrypt failed", e);
        }
    }

    public byte[] format(byte[] encryptData) throws Exception {
        ASN1SM2Cipher cipher = ASN1SM2Cipher.getInstance((Object)encryptData);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(cipher.getXCoordinate().getPositiveValue()));
        v.add((ASN1Encodable)new ASN1Integer(cipher.getYCoordinate().getPositiveValue()));
        v.add((ASN1Encodable)cipher.getHashValue());
        v.add((ASN1Encodable)cipher.getCipherText());
        return new DERSequence(v).getEncoded("DER");
    }
}

