/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.tls.pure.CryptoException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class SM2Format {
    private SM2Format() {
    }

    public static byte[] formatEncryptResult(byte[] encryptData) throws Exception {
        ASN1SM2Cipher cipher = ASN1SM2Cipher.getInstance((Object)encryptData);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(cipher.getXCoordinate().getPositiveValue()));
        v.add((ASN1Encodable)new ASN1Integer(cipher.getYCoordinate().getPositiveValue()));
        v.add((ASN1Encodable)cipher.getHashValue());
        v.add((ASN1Encodable)cipher.getCipherText());
        return new DERSequence(v).getEncoded("DER");
    }

    public static byte[] formatSignResult(byte[] signBytes) throws IOException {
        if (signBytes == null || signBytes.length != 64) {
            throw new CryptoException("signBytes==null/length!=64");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(signBytes, 0, 32))));
        v.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(signBytes, 32, 64))));
        return new DERSequence(v).getEncoded("DER");
    }
}

