/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.tls.pure.CryptoException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2Helper {
    static final Mechanism mechanism_sm2 = new Mechanism("SM2");

    private SM2Helper() {
    }

    public static boolean isSM2Type(String suitType, String keyType) {
        return "SM2".equals(suitType) && ("SM2".equals(keyType) || "EC".equals(keyType));
    }

    public static boolean isSM2Type(String algorithm) {
        return "SM2".equals(algorithm) || "EC".equals(algorithm);
    }

    public static GMTKey form(PrivateKey sm2PrivateKey) throws CryptoException {
        if (sm2PrivateKey == null) {
            throw new CryptoException("sm2PrivateKey==null");
        }
        GMTKey sm2Key = null;
        if (sm2PrivateKey instanceof GMTKey) {
            sm2Key = (GMTKey)sm2PrivateKey;
        } else if (sm2PrivateKey instanceof java.security.interfaces.ECPrivateKey) {
            BigInteger sInt = ((java.security.interfaces.ECPrivateKey)sm2PrivateKey).getS();
            sm2Key = SM2Helper.formPrivateKey(sInt);
        } else if (sm2PrivateKey instanceof ECPrivateKey) {
            BigInteger sInt = ((ECPrivateKey)sm2PrivateKey).getD();
            sm2Key = SM2Helper.formPrivateKey(sInt);
        } else {
            throw new CryptoException("sm2PrivateKey invalid: " + sm2PrivateKey.getClass().getName());
        }
        return sm2Key;
    }

    public static GMTKey form(PublicKey sm2PublicKey) throws CryptoException {
        if (sm2PublicKey == null) {
            throw new CryptoException("sm2PublicKey==null");
        }
        GMTKey sm2Key = null;
        if (sm2PublicKey instanceof GMTKey) {
            sm2Key = (GMTKey)sm2PublicKey;
        } else if (sm2PublicKey instanceof java.security.interfaces.ECPublicKey) {
            java.security.spec.ECPoint wPoint = ((java.security.interfaces.ECPublicKey)sm2PublicKey).getW();
            BigInteger iPubX = wPoint.getAffineX();
            BigInteger iPubY = wPoint.getAffineY();
            sm2Key = SM2Helper.formPublicKey(iPubX, iPubY);
        } else if (sm2PublicKey instanceof ECPublicKey) {
            ECPoint wPoint = ((ECPublicKey)sm2PublicKey).getQ();
            BigInteger iPubX = wPoint.getAffineXCoord().toBigInteger();
            BigInteger iPubY = wPoint.getAffineYCoord().toBigInteger();
            sm2Key = SM2Helper.formPublicKey(iPubX, iPubY);
        } else {
            throw new CryptoException("sm2PublicKey invalid: " + sm2PublicKey.getClass().getName());
        }
        return sm2Key;
    }

    public static SM2PrivateKey formPrivateKey(byte[] encoding) {
        try {
            return new SM2PrivateKey(encoding);
        }
        catch (Exception e) {
            throw new CryptoException("PrivateKeyInvalid", e);
        }
    }

    public static SM2PrivateKey formPrivateKey(BigInteger sInt) {
        try {
            return new SM2PrivateKey(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)sInt));
        }
        catch (Exception e) {
            throw new CryptoException("PrivateKeyInvalid", e);
        }
    }

    public static SM2PublicKey formPublicKey(BigInteger pubx, BigInteger puby) {
        try {
            return new SM2PublicKey(pubx, puby);
        }
        catch (Exception e) {
            throw new CryptoException("PublicKeyInvalid", e);
        }
    }

    public static SM2PublicKey formPublicKey(byte[] pointBytes) {
        try {
            return new SM2PublicKey(pointBytes);
        }
        catch (Exception e) {
            throw new CryptoException("PublicKeyInvalid", e);
        }
    }
}

