/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

public enum AlertDescription {
    alert_close_notify(0, "close_notify", false),
    alert_unexpected_message(10, "unexpected_message", false),
    alert_bad_record_mac(20, "bad_record_mac", false),
    alert_decryption_failed(21, "decryption_failed", false),
    alert_record_overflow(22, "record_overflow", false),
    alert_decompression_failure(30, "decompression_failure", false),
    alert_handshake_failure(40, "handshake_failure", true),
    alert_no_certificate(41, "no_certificate", true),
    alert_bad_certificate(42, "bad_certificate", true),
    alert_unsupported_certificate(43, "unsupported_certificate", true),
    alert_certificate_revoked(44, "certificate_revoked", true),
    alert_certificate_expired(45, "certificate_expired", true),
    alert_certificate_unknown(46, "certificate_unknown", true),
    alert_illegal_parameter(47, "illegal_parameter", false),
    alert_unknown_ca(48, "unknown_ca", true),
    alert_access_denied(49, "access_denied", true),
    alert_decode_error(50, "decode_error", false),
    alert_decrypt_error(51, "decrypt_error", true),
    alert_export_restriction(60, "export_restriction", true),
    alert_protocol_version(70, "protocol_version", false),
    alert_insufficient_security(71, "insufficient_security", true),
    alert_internal_error(80, "internal_error", false),
    alert_user_canceled(90, "user_canceled", false),
    alert_no_renegotiation(100, "no_renegotiation", false),
    alert_unsupported_extension(110, "unsupported_extension", true),
    alert_certificate_unobtainable(111, "certificate_unobtainable", true),
    alert_unrecognized_name(112, "unrecognized_name", true),
    alert_bad_certificate_status_response(113, "bad_certificate_status_response", true),
    alert_bad_certificate_hash_value(114, "bad_certificate_hash_value", true),
    alert_unsupported_site2site(-56, "unsupported_site2site", true),
    alert_no_area(-55, "no_area", true),
    alert_unsupported_areatype(-54, "unsupported_areatype", true),
    alert_bad_ibcparam(-53, "bad_ibcparam", true),
    alert_unsupported_ibcparam(-52, "unsupported_ibcparam", true),
    alert_identity_need(-51, "identity_need", true);

    public final byte code;
    public final String desc;
    public boolean handshake;
    private static AlertDescription[] values;

    private AlertDescription(byte code, String desc, boolean handshake) {
        this.code = code;
        this.desc = desc;
        this.handshake = handshake;
    }

    private static final AlertDescription[] build() {
        AlertDescription[] values;
        AlertDescription[] results = new AlertDescription[256];
        AlertDescription[] arr$ = values = AlertDescription.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            AlertDescription value;
            results[value.code & 0xFF] = value = arr$[i$];
        }
        return results;
    }

    public static AlertDescription find(byte level) {
        return values[level & 0xFF];
    }

    static {
        values = AlertDescription.build();
    }
}

