/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.org.slf4j.Logger;
import cfca.sadk.tls.sun.security.ssl.AlertDescription;
import cfca.sadk.tls.sun.security.ssl.AlertLevel;
import cfca.sadk.tls.sun.security.ssl.Alerts;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.CertificateRequest;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import cfca.sadk.tls.util.Loggings;
import cfca.sadk.tls.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class Debugger {
    public static final Logger handshaker = Loggings.handshaker;
    public static final Logger datashaker = Loggings.datashaker;
    public static final boolean debugGmsslVersion = GMSSLConstants.debugGmsslVersion;
    public static final boolean debugHandshakerFull = GMSSLConstants.debugHandshakerFull;
    public static int dumpLength = 8192;

    private Debugger() {
    }

    public static final void debug(HandshakeMessage message) {
        if (message != null && handshaker.isDebugEnabled()) {
            handshaker.debug("{}", (Object)message);
            if (message instanceof CertificateRequest) {
                CertificateRequest certRequest = (CertificateRequest)message;
                try {
                    X500Principal[] cas = certRequest.getAuthorities();
                    if (cas != null) {
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < cas.length; ++i) {
                            builder.append('\n');
                            builder.append("CAs: ");
                            builder.append(cas[i]);
                        }
                        builder.append('\n');
                        handshaker.debug(builder.toString());
                        Object var3_4 = null;
                    }
                }
                catch (IOException e) {
                    handshaker.debug("certRequest authorities failed", (Throwable)e);
                }
            }
        }
    }

    public static final void debug(String operation, ProtocolVersion version, AlertLevel level, AlertDescription description) {
        if (handshaker.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append(operation).append(' ').append(version).append(" ALERT:  ");
            if (level == AlertLevel.alert_fatal) {
                builder.append("fatal, ");
            } else if (level == AlertLevel.alert_warning) {
                builder.append("warning, ");
            } else {
                builder.append("<level " + (0xFF & level.level) + ">, ");
            }
            builder.append("\ndescription = " + Alerts.alertDescription(description));
            handshaker.debug(builder.toString());
        }
    }

    public static final String dump(X509Certificate cert) {
        String message = null;
        try {
            message = cert == null ? "none" : cert.toString();
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static final String dump(X509Certificate[] certs) {
        String message = null;
        try {
            if (certs == null || certs.length == 0) {
                message = "none";
            } else {
                StringBuilder build = new StringBuilder(1280 * certs.length);
                for (int i = 0; i < certs.length; ++i) {
                    build.append(certs[i]);
                }
                message = build.toString();
            }
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static int length(byte[] data) {
        return data == null ? -1 : data.length;
    }

    public static int length(Object[] data) {
        return data == null ? -1 : data.length;
    }

    public static int length(InputStream data) {
        try {
            return data == null ? -1 : data.available();
        }
        catch (IOException e) {
            return -2;
        }
    }

    public static String dump(byte[] data) {
        String message = null;
        try {
            message = data == null || data.length == 0 ? "none" : (data.length > dumpLength ? Strings.encodeBase64(data, 0, 80) + "...[more than 8K]" : Strings.encodeBase64(data));
        }
        catch (Exception e) {
            message = "dump[base64]Failed";
        }
        return message;
    }

    public static String dump(String data) {
        String message = null;
        message = data == null || data.length() == 0 ? "none" : (data.length() > dumpLength ? data.substring(0, 80) + "...[more than 10K]" : data);
        return message;
    }
}

