/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.AlertDescription;
import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.Record;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import cfca.sadk.tls.sun.security.ssl.sec.MAC;
import cfca.sadk.tls.util.Hex;
import cfca.sadk.tls.util.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLException;

class OutputRecord
extends ByteArrayOutputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    private boolean firstMessage = true;
    private final byte contentType;
    private int headerOffset;
    ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private ProtocolVersion helloVersion = ProtocolVersion.TLS11SM;
    private static int[] V3toV2CipherMap1 = new int[]{-1, -1, -1, 2, 1, -1, 4, 5, -1, 6, 7};
    private static int[] V3toV2CipherMap3 = new int[]{-1, -1, -1, 128, 128, -1, 128, 128, -1, 64, 192};

    OutputRecord(byte type, int size) {
        super(size);
        this.count = 261;
        this.contentType = type;
        this.lastHashed = this.count;
        this.headerOffset = 256;
    }

    OutputRecord(byte type) {
        this(type, OutputRecord.recordSize(type));
    }

    private static int recordSize(byte type) {
        if (type == 20 || type == 21) {
            return 539;
        }
        return 16921;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    synchronized void setHelloVersion(ProtocolVersion helloVersion) {
        this.helloVersion = helloVersion;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastHashed = this.count = 261;
        this.headerOffset = 256;
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        assert (this.contentType == 22);
        this.handshakeHash = handshakeHash;
    }

    void doHashes() {
        int len = this.count - this.lastHashed;
        if (len > 0) {
            this.hashInternal(this.buf, this.lastHashed, len);
            this.lastHashed = this.count;
        }
    }

    private void hashInternal(byte[] buf, int offset, int len) {
        if (Debugger.datashaker.isDebugEnabled()) {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("\n[read] MD5 and SHA1 hashes:  len = ").append(len);
                builder.append('\n');
                builder.append((CharSequence)Hex.dump("", buf, this.lastHashed, len));
                Debugger.datashaker.debug(builder.toString());
                builder = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.handshakeHash.update(buf, this.lastHashed, len);
        this.lastHashed = this.count;
    }

    boolean isEmpty() {
        return this.count == 261;
    }

    boolean isAlert(AlertDescription description) {
        if (this.count > 262 && this.contentType == 21) {
            return this.buf[262] == description.code;
        }
        return false;
    }

    void encrypt(Authenticator authenticator, CipherBox box) throws IOException {
        MAC signer;
        if (this.contentType == 22) {
            this.doHashes();
        }
        if (authenticator instanceof MAC && (signer = (MAC)authenticator).MAClen() != 0) {
            byte[] hash = signer.compute(this.contentType, this.buf, 261, this.count - 261, false);
            this.write(hash);
        }
        if (!box.isNullCipher()) {
            if (this.protocolVersion.isTLS11() && box.isCBCMode()) {
                byte[] nonce = box.createExplicitNonce(authenticator, this.contentType, this.count - 261);
                int offset = 261 - nonce.length;
                System.arraycopy(nonce, 0, this.buf, offset, nonce.length);
                this.headerOffset = offset - 5;
            } else {
                this.headerOffset = 256;
            }
            int offset = 261;
            offset = this.headerOffset + 5;
            this.count = offset + box.encrypt(this.buf, offset, this.count - offset);
        }
    }

    final int availableDataBytes() {
        int dataSize = this.count - 261;
        return 16384 - dataSize;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buf.length) {
            this.buf = Utilities.copyOf(this.buf, minCapacity);
        }
    }

    final byte contentType() {
        return this.contentType;
    }

    void write(OutputStream s, boolean holdRecord, ByteArrayOutputStream heldRecordBuffer) throws IOException {
        if (this.count == 261) {
            return;
        }
        int length = this.count - this.headerOffset - 5;
        if (length < 0) {
            throw new SSLException("output record size too small: " + length);
        }
        if (Debugger.datashaker.isDebugEnabled()) {
            Debugger.datashaker.debug(" WRITE: {} {}, length = {}", new Object[]{this.protocolVersion, InputRecord.contentName(this.contentType()), length});
        }
        if (this.firstMessage && this.useV2Hello()) {
            byte[] v3Msg = new byte[length - 4];
            System.arraycopy(this.buf, 265, v3Msg, 0, v3Msg.length);
            this.headerOffset = 0;
            this.V3toV2ClientHello(v3Msg);
            this.handshakeHash.reset();
            this.lastHashed = 2;
            this.doHashes();
            if (Debugger.datashaker.isDebugEnabled()) {
                Debugger.datashaker.debug("WRITE: SSLv2 client hello message , length = {}", (Object)(this.count - 2));
            }
        } else {
            this.buf[this.headerOffset + 0] = this.contentType;
            this.buf[this.headerOffset + 1] = this.protocolVersion.major;
            this.buf[this.headerOffset + 2] = this.protocolVersion.minor;
            this.buf[this.headerOffset + 3] = (byte)(length >> 8);
            this.buf[this.headerOffset + 4] = (byte)length;
        }
        this.firstMessage = false;
        int debugOffset = 0;
        if (holdRecord) {
            this.writeBuffer(heldRecordBuffer, this.buf, this.headerOffset, this.count - this.headerOffset, debugOffset);
        } else {
            if (heldRecordBuffer != null && heldRecordBuffer.size() > 0) {
                int heldLen = heldRecordBuffer.size();
                int newCount = this.count + heldLen - this.headerOffset;
                this.ensureCapacity(newCount);
                System.arraycopy(this.buf, this.headerOffset, this.buf, heldLen, this.count - this.headerOffset);
                System.arraycopy(heldRecordBuffer.toByteArray(), 0, this.buf, 0, heldLen);
                this.count = newCount;
                this.headerOffset = 0;
                heldRecordBuffer.reset();
                debugOffset = heldLen;
            }
            this.writeBuffer(s, this.buf, this.headerOffset, this.count - this.headerOffset, debugOffset);
        }
        this.reset();
    }

    void writeBuffer(OutputStream s, byte[] buf, int off, int len, int debugOffset) throws IOException {
        s.write(buf, off, len);
        s.flush();
        if (Debugger.datashaker.isDebugEnabled()) {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("\n[Raw write]: length =").append(len - debugOffset);
                builder.append('\n');
                builder.append((CharSequence)Hex.dump("", buf, off + debugOffset, len - debugOffset));
                Debugger.datashaker.debug(builder.toString());
                builder = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private boolean useV2Hello() {
        return this.firstMessage && this.helloVersion == ProtocolVersion.SSL20Hello && this.contentType == 22 && this.buf[this.headerOffset + 5] == 1 && this.buf[299] == 0;
    }

    private void V3toV2ClientHello(byte[] v3Msg) throws SSLException {
        int v3SessionIdLenOffset = 34;
        byte v3SessionIdLen = v3Msg[v3SessionIdLenOffset];
        int v3CipherSpecLenOffset = v3SessionIdLenOffset + 1 + v3SessionIdLen;
        int v3CipherSpecLen = ((v3Msg[v3CipherSpecLenOffset] & 0xFF) << 8) + (v3Msg[v3CipherSpecLenOffset + 1] & 0xFF);
        int cipherSpecs = v3CipherSpecLen / 2;
        int v3CipherSpecOffset = v3CipherSpecLenOffset + 2;
        int v2CipherSpecLen = 0;
        this.count = 11;
        boolean containsRenegoInfoSCSV = false;
        for (int i = 0; i < cipherSpecs; ++i) {
            byte byte1 = v3Msg[v3CipherSpecOffset++];
            byte byte2 = v3Msg[v3CipherSpecOffset++];
            v2CipherSpecLen += this.V3toV2CipherSuite(byte1, byte2);
            if (containsRenegoInfoSCSV || byte1 != 0 || byte2 != -1) continue;
            containsRenegoInfoSCSV = true;
        }
        if (!containsRenegoInfoSCSV) {
            v2CipherSpecLen += this.V3toV2CipherSuite((byte)0, (byte)-1);
        }
        this.buf[2] = 1;
        this.buf[3] = v3Msg[0];
        this.buf[4] = v3Msg[1];
        this.buf[5] = (byte)(v2CipherSpecLen >>> 8);
        this.buf[6] = (byte)v2CipherSpecLen;
        this.buf[7] = 0;
        this.buf[8] = 0;
        this.buf[9] = 0;
        this.buf[10] = 32;
        System.arraycopy(v3Msg, 2, this.buf, this.count, 32);
        this.count += 32;
        this.count -= 2;
        this.buf[0] = (byte)(this.count >>> 8);
        this.buf[0] = (byte)(this.buf[0] | 0x80);
        this.buf[1] = (byte)this.count;
        this.count += 2;
    }

    private int V3toV2CipherSuite(byte byte1, byte byte2) {
        this.buf[this.count++] = 0;
        this.buf[this.count++] = byte1;
        this.buf[this.count++] = byte2;
        if ((byte2 & 0xFF) > 10 || V3toV2CipherMap1[byte2] == -1) {
            return 3;
        }
        this.buf[this.count++] = (byte)V3toV2CipherMap1[byte2];
        this.buf[this.count++] = 0;
        this.buf[this.count++] = (byte)V3toV2CipherMap3[byte2];
        return 6;
    }
}

