/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.javax.net.ssl.GMSSLEngine;
import cfca.sadk.tls.javax.net.ssl.GMSSLParameters;
import cfca.sadk.tls.sun.security.ssl.AbstractKeyManagerWrapper;
import cfca.sadk.tls.sun.security.ssl.AbstractTrustManagerWrapper;
import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.DummyX509KeyManager;
import cfca.sadk.tls.sun.security.ssl.DummyX509TrustManager;
import cfca.sadk.tls.sun.security.ssl.ProtocolList;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.SSLServerSocketFactoryImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSocketFactoryImpl;
import cfca.sadk.tls.sun.security.ssl.manager.GMX509ExtendedTrustManager;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.SSLAlgorithmConstraints;
import cfca.sadk.tls.sun.security.ssl.sec.SecureRandoms;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.GMCryptoPrimitive;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.EnumSet;
import java.util.TreeSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class SSLContextImpl
extends SSLContextSpi {
    private final SSLSessionContextImpl clientCache;
    private final SSLSessionContextImpl serverCache;
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private GMAlgorithmConstraints defaultAlgorithmConstraints = new SSLAlgorithmConstraints(null);
    private ProtocolList defaultServerProtocolList;
    private ProtocolList defaultClientProtocolList;
    private ProtocolList supportedProtocolList;
    private CipherSuiteList defaultServerCipherSuiteList;
    private CipherSuiteList defaultClientCipherSuiteList;
    private CipherSuiteList supportedCipherSuiteList;

    SSLContextImpl() {
        this.clientCache = new SSLSessionContextImpl();
        this.serverCache = new SSLSessionContextImpl();
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(km);
        if (tm == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tm = tmf.getTrustManagers();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(tm);
        this.secureRandom = sr == null ? SecureRandoms.newSecure() : sr;
        Debugger.handshaker.debug("trigger seeding of SecureRandom");
        this.secureRandom.nextInt();
        Debugger.handshaker.debug("done seeding of SecureRandom");
        this.isInitialized = true;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    @Override
    protected GMSSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this);
    }

    @Override
    protected GMSSLEngine engineCreateSSLEngine(String host, int port) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this, host, port);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] tm) throws KeyManagementException {
        X509TrustManager trustManager = null;
        for (int i = 0; tm != null && i < tm.length; ++i) {
            if (!(tm[i] instanceof X509TrustManager)) continue;
            if (tm[i] instanceof GMX509ExtendedTrustManager) {
                Debugger.handshaker.debug("chooseTrustManager: choose tm-{} is X509TrustManager", (Object)i);
                trustManager = (X509TrustManager)tm[i];
                break;
            }
            Debugger.handshaker.debug("chooseTrustManager: convert tm-{} to AbstractTrustManagerWrapper", (Object)i);
            trustManager = new AbstractTrustManagerWrapper((X509TrustManager)tm[i]);
            break;
        }
        if (trustManager == null) {
            Debugger.handshaker.debug("chooseTrustManager: nothing found, return DummyX509TrustManager");
            trustManager = DummyX509TrustManager.INSTANCE;
        }
        return trustManager;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] kms) throws KeyManagementException {
        X509ExtendedKeyManager keyManager = null;
        for (int i = 0; kms != null && i < kms.length; ++i) {
            KeyManager km = kms[i];
            if (!(km instanceof X509KeyManager)) continue;
            if (km instanceof X509ExtendedKeyManager) {
                Debugger.handshaker.debug("chooseKeyManager: choose km-{} is X509ExtendedKeyManager", (Object)i);
                keyManager = (X509ExtendedKeyManager)km;
                break;
            }
            Debugger.handshaker.debug("chooseKeyManager: convert km-{} to AbstractKeyManagerWrapper", (Object)i);
            keyManager = new AbstractKeyManagerWrapper((X509KeyManager)km);
            break;
        }
        if (keyManager == null) {
            Debugger.handshaker.debug("chooseKeyManager: nothing found, return DummyX509KeyManager");
            keyManager = DummyX509KeyManager.INSTANCE;
        }
        return keyManager;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    abstract GMSSLParameters getDefaultServerSSLParams();

    abstract GMSSLParameters getDefaultClientSSLParams();

    abstract GMSSLParameters getSupportedSSLParams();

    ProtocolList getSuportedProtocolList() {
        if (this.supportedProtocolList == null) {
            this.supportedProtocolList = new ProtocolList(this.getSupportedSSLParams().getProtocols());
        }
        return this.supportedProtocolList;
    }

    ProtocolList getDefaultProtocolList(boolean roleIsServer) {
        if (roleIsServer) {
            if (this.defaultServerProtocolList == null) {
                this.defaultServerProtocolList = new ProtocolList(this.getDefaultServerSSLParams().getProtocols());
            }
            return this.defaultServerProtocolList;
        }
        if (this.defaultClientProtocolList == null) {
            this.defaultClientProtocolList = new ProtocolList(this.getDefaultClientSSLParams().getProtocols());
        }
        return this.defaultClientProtocolList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherSuiteList getSupportedCipherSuiteList() {
        SSLContextImpl sSLContextImpl = this;
        synchronized (sSLContextImpl) {
            this.clearAvailableCache();
            if (this.supportedCipherSuiteList == null) {
                this.supportedCipherSuiteList = this.getApplicableCipherSuiteList(this.getSuportedProtocolList(), false);
            }
            return this.supportedCipherSuiteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherSuiteList getDefaultCipherSuiteList(boolean roleIsServer) {
        SSLContextImpl sSLContextImpl = this;
        synchronized (sSLContextImpl) {
            this.clearAvailableCache();
            if (roleIsServer) {
                if (this.defaultServerCipherSuiteList == null) {
                    this.defaultServerCipherSuiteList = this.getApplicableCipherSuiteList(this.getDefaultProtocolList(true), true);
                }
                return this.defaultServerCipherSuiteList;
            }
            if (this.defaultClientCipherSuiteList == null) {
                this.defaultClientCipherSuiteList = this.getApplicableCipherSuiteList(this.getDefaultProtocolList(false), true);
            }
            return this.defaultClientCipherSuiteList;
        }
    }

    boolean isDefaultProtocolList(ProtocolList protocols) {
        return protocols == this.defaultServerProtocolList || protocols == this.defaultClientProtocolList;
    }

    private CipherSuiteList getApplicableCipherSuiteList(ProtocolList protocols, boolean onlyEnabled) {
        int minPriority = 1;
        if (onlyEnabled) {
            minPriority = 300;
        }
        Collection<CipherSuite> allowedCipherSuites = CipherSuite.allowedCipherSuites();
        TreeSet<CipherSuite> suites = new TreeSet<CipherSuite>();
        if (!protocols.collection().isEmpty() && protocols.min.version != ProtocolVersion.NONE.version) {
            for (CipherSuite suite : allowedCipherSuites) {
                if (!suite.allowed || suite.priority < minPriority) continue;
                if (suite.isAvailable() && suite.obsoleted > protocols.min.version && suite.supported <= protocols.max.version) {
                    if (!this.defaultAlgorithmConstraints.permits(EnumSet.of(GMCryptoPrimitive.KEY_AGREEMENT), suite.name, null)) continue;
                    suites.add(suite);
                    continue;
                }
                if (!Debugger.handshaker.isDebugEnabled()) continue;
                if (suite.obsoleted <= protocols.min.version) {
                    Debugger.handshaker.debug("Ignoring obsoleted cipher suite: " + suite);
                    continue;
                }
                if (suite.supported > protocols.max.version) {
                    Debugger.handshaker.debug("Ignoring unsupported cipher suite: " + suite);
                    continue;
                }
                Debugger.handshaker.debug("Ignoring unavailable cipher suite: " + suite);
            }
        }
        return new CipherSuiteList(suites);
    }

    private void clearAvailableCache() {
        this.supportedCipherSuiteList = null;
        this.defaultServerCipherSuiteList = null;
        this.defaultClientCipherSuiteList = null;
    }

    public static final class TLSContext
    extends CustomizedSSLContext {
    }

    private static class CustomizedSSLContext
    extends AbstractSSLContext {
        private static final GMSSLParameters defaultClientSSLParams;
        private static IllegalArgumentException reservedException;

        protected CustomizedSSLContext() {
            if (reservedException != null) {
                throw reservedException;
            }
        }

        @Override
        GMSSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        static {
            reservedException = null;
            String property = GMSSLConstants.clientSSLProtocols;
            defaultClientSSLParams = new GMSSLParameters();
            if (property == null || property.length() == 0) {
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS11SM.name});
            } else {
                if (property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                    property = property.substring(1, property.length() - 1);
                }
                String[] protocols = property.split(",");
                for (int i = 0; i < protocols.length; ++i) {
                    protocols[i] = protocols[i].trim();
                    try {
                        ProtocolVersion.valueOf(protocols[i]);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        reservedException = new IllegalArgumentException("gmssl.clientProtocols: " + protocols[i] + " is not a standard SSL protocol name", iae);
                    }
                }
                if (reservedException == null) {
                    defaultClientSSLParams.setProtocols(protocols);
                }
            }
        }
    }

    public static final class TLS12Context
    extends AbstractSSLContext {
        private static final GMSSLParameters defaultClientSSLParams = new GMSSLParameters();

        @Override
        GMSSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        static {
            defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS11SM.name});
        }
    }

    public static final class TLS11Context
    extends AbstractSSLContext {
        private static final GMSSLParameters defaultClientSSLParams = new GMSSLParameters();

        @Override
        GMSSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        static {
            defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS11SM.name});
        }
    }

    private static abstract class AbstractSSLContext
    extends SSLContextImpl {
        private static final GMSSLParameters defaultServerSSLParams;
        private static final GMSSLParameters supportedSSLParams;

        private AbstractSSLContext() {
        }

        @Override
        GMSSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        GMSSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            supportedSSLParams = new GMSSLParameters();
            supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS11SM.name});
            defaultServerSSLParams = supportedSSLParams;
        }
    }
}

