/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.javax.net.ssl.GMSSLSession;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.SSLSessionContextImpl;
import cfca.sadk.tls.sun.security.ssl.SecureKey;
import cfca.sadk.tls.sun.security.ssl.SessionId;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.SSLCredentials;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class SSLSessionImpl
extends GMSSLSession {
    static final SSLSessionImpl nullSession = new SSLSessionImpl();
    private static final byte compression_null = 0;
    private final ProtocolVersion protocolVersion;
    private final SessionId sessionId;
    private byte compressionMethod;
    private CipherSuite cipherSuite;
    private SecretKey masterSecret;
    private final long creationTime = System.currentTimeMillis();
    private long lastUsedTime = 0L;
    private final String host;
    private final int port;
    private SSLSessionContextImpl context;
    private int sessionCount;
    private boolean invalidated;
    private SSLCredentials peerSignerCredentials;
    private SSLCredentials peerCipherCredentials;
    private SSLCredentials localSignerCredentials;
    private SSLCredentials localCipherCredentials;
    private String[] localSupportedSignAlgs;
    private String[] peerSupportedSignAlgs;
    private Principal peerPrincipal;
    private Principal localPrincipal;
    private static volatile int counter = 0;
    private static boolean defaultRejoinable = true;
    private Hashtable<SecureKey, Object> table = new Hashtable();
    private boolean acceptLargeFragments = GMSSLConstants.acceptLargeFragments;

    private SSLSessionImpl() {
        this(ProtocolVersion.NONE, CipherSuite.C_NULL, null, new SessionId(false, null), null, -1);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, Collection<SignatureAndHashAlgorithm> algorithms, SecureRandom generator, String host, int port) {
        this(protocolVersion, cipherSuite, algorithms, new SessionId(defaultRejoinable, generator), host, port);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, Collection<SignatureAndHashAlgorithm> algorithms, SessionId id, String host, int port) {
        this.protocolVersion = protocolVersion;
        this.sessionId = id;
        this.peerSignerCredentials = null;
        this.peerCipherCredentials = null;
        this.compressionMethod = 0;
        this.cipherSuite = cipherSuite;
        this.masterSecret = null;
        this.host = host;
        this.port = port;
        this.sessionCount = ++counter;
        this.localSupportedSignAlgs = SignatureAndHashAlgorithm.getAlgorithmNames(algorithms);
        Debugger.handshaker.debug("%% Initialized:  {}", (Object)this);
    }

    void setMasterSecret(SecretKey secret) {
        if (this.masterSecret != null) {
            throw new RuntimeException("setMasterSecret() error");
        }
        this.masterSecret = secret;
    }

    SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    final void setPeerCredentials(SSLCredentials signer, SSLCredentials cipher) {
        if (this.peerSignerCredentials == null || this.peerCipherCredentials == null) {
            this.peerSignerCredentials = signer;
            this.peerCipherCredentials = cipher;
        }
    }

    final void setLocalCredentials(SSLCredentials signer, SSLCredentials cipher) {
        if (this.localSignerCredentials == null || this.localCipherCredentials == null) {
            this.localSignerCredentials = signer;
            this.localCipherCredentials = cipher;
        }
    }

    public final SSLCredentials getPeerSignerCredentials() throws SSLPeerUnverifiedException {
        if (this.peerSignerCredentials == null || !this.peerSignerCredentials.hasCertificates()) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerSignerCredentials;
    }

    public final SSLCredentials getPeerCipherCredentials() {
        if (this.peerCipherCredentials == null || !this.peerCipherCredentials.hasCertificates()) {
            return new SSLCredentials(null, null);
        }
        return this.peerCipherCredentials;
    }

    public final SSLCredentials getLocalSignerCredentials() {
        if (this.localSignerCredentials == null || !this.localSignerCredentials.hasCertificates()) {
            return new SSLCredentials(null, null);
        }
        return this.localSignerCredentials;
    }

    public final SSLCredentials getLocalCipherCredentials() {
        if (this.localCipherCredentials == null || !this.localCipherCredentials.hasCertificates()) {
            return new SSLCredentials(null, null);
        }
        return this.localCipherCredentials;
    }

    void setPeerSupportedSignatureAlgorithms(Collection<SignatureAndHashAlgorithm> algorithms) {
        this.peerSupportedSignAlgs = SignatureAndHashAlgorithm.getAlgorithmNames(algorithms);
    }

    void setPeerPrincipal(Principal principal) {
        if (this.peerPrincipal == null) {
            this.peerPrincipal = principal;
        }
    }

    void setLocalPrincipal(Principal principal) {
        this.localPrincipal = principal;
    }

    boolean isRejoinable() {
        return this.sessionId != null && this.sessionId.length() != 0 && !this.invalidated && this.isLocalAuthenticationValid();
    }

    @Override
    public synchronized boolean isValid() {
        return this.isRejoinable();
    }

    boolean isLocalAuthenticationValid() {
        if (this.localSignerCredentials != null && this.localSignerCredentials.privateKey != null) {
            try {
                this.localSignerCredentials.privateKey.getAlgorithm();
            }
            catch (Exception e) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] getId() {
        return this.sessionId.getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    SessionId getSessionId() {
        return this.sessionId;
    }

    CipherSuite getSuite() {
        return this.cipherSuite;
    }

    void setSuite(CipherSuite suite) {
        this.cipherSuite = suite;
        Debugger.handshaker.debug("%% Negotiating:  {}", (Object)this);
    }

    @Override
    public String getCipherSuite() {
        return this.getSuite().name;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.getProtocolVersion().name;
    }

    byte getCompression() {
        return this.compressionMethod;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SSLSessionImpl) {
            SSLSessionImpl sess = (SSLSessionImpl)obj;
            return this.sessionId != null && this.sessionId.equals(sess.getSessionId());
        }
        return false;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerSignerCredentials == null || this.peerSignerCredentials.certificates == null) {
            throw new SSLPeerUnverifiedException("peer signer not authenticated");
        }
        java.security.cert.X509Certificate[] signers = this.peerSignerCredentials.certificates;
        java.security.cert.X509Certificate[] ciphers = this.peerCipherCredentials == null ? null : this.peerCipherCredentials.certificates;
        Certificate[] certs = SSLCredentials.concat(signers, ciphers);
        return certs;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        if (this.localSignerCredentials == null || this.localSignerCredentials.certificates == null) {
            return null;
        }
        java.security.cert.X509Certificate[] signers = this.localSignerCredentials.certificates;
        java.security.cert.X509Certificate[] ciphers = this.localCipherCredentials == null ? null : this.localCipherCredentials.certificates;
        Certificate[] certs = SSLCredentials.concat(signers, ciphers);
        return certs;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerSignerCredentials == null || !this.peerSignerCredentials.hasCertificates()) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        Certificate[] peers = this.getPeerCertificates();
        X509Certificate[] certs = new X509Certificate[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            byte[] der = null;
            try {
                der = peers[i].getEncoded();
                certs[i] = X509Certificate.getInstance(der);
                continue;
            }
            catch (CertificateEncodingException e) {
                throw new SSLPeerUnverifiedException(e.getMessage());
            }
            catch (CertificateException e) {
                throw new SSLPeerUnverifiedException(e.getMessage());
            }
        }
        return certs;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerSignerCredentials == null || !this.peerSignerCredentials.hasCertificates()) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        Certificate[] peers = this.getPeerCertificates();
        java.security.cert.X509Certificate[] certs = new java.security.cert.X509Certificate[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            certs[i] = (java.security.cert.X509Certificate)peers[i];
        }
        return certs;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.peerSignerCredentials == null || !this.peerSignerCredentials.hasCertificates()) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerSignerCredentials.getPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.localSignerCredentials == null || !this.localSignerCredentials.hasCertificates()) {
            return null;
        }
        return this.localSignerCredentials.getPrincipal();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastUsedTime != 0L ? this.lastUsedTime : this.creationTime;
    }

    void setLastAccessedTime(long time) {
        this.lastUsedTime = time;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public int getPeerPort() {
        return this.port;
    }

    void setContext(SSLSessionContextImpl ctx) {
        if (this.context == null) {
            this.context = ctx;
        }
    }

    @Override
    public synchronized void invalidate() {
        if (this == nullSession) {
            return;
        }
        this.invalidated = true;
        Debugger.handshaker.debug("%% Invalidated:  {}", (Object)this);
        if (this.context != null) {
            this.context.remove(this.sessionId);
            this.context = null;
        }
    }

    @Override
    public void putValue(String key, Object value) {
        SSLSessionBindingEvent e;
        if (key == null || value == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        Object oldValue = this.table.put(secureKey, value);
        if (oldValue instanceof SSLSessionBindingListener) {
            e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)oldValue).valueUnbound(e);
        }
        if (value instanceof SSLSessionBindingListener) {
            e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)value).valueBound(e);
        }
    }

    @Override
    public Object getValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        return this.table.get(secureKey);
    }

    @Override
    public void removeValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        Object value = this.table.remove(secureKey);
        if (value instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)value).valueUnbound(e);
        }
    }

    @Override
    public String[] getValueNames() {
        Vector<Object> v = new Vector<Object>();
        Object securityCtx = SecureKey.getCurrentSecurityContext();
        Enumeration<SecureKey> e = this.table.keys();
        while (e.hasMoreElements()) {
            SecureKey key = e.nextElement();
            if (!securityCtx.equals(key.getSecurityContext())) continue;
            v.addElement(key.getAppKey());
        }
        Object[] names = new String[v.size()];
        v.copyInto(names);
        return names;
    }

    protected synchronized void expandBufferSizes() {
        this.acceptLargeFragments = true;
    }

    @Override
    public synchronized int getPacketBufferSize() {
        return this.acceptLargeFragments ? 33305 : 16921;
    }

    @Override
    public synchronized int getApplicationBufferSize() {
        return this.getPacketBufferSize() - 5;
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        if (this.localSupportedSignAlgs != null) {
            return (String[])this.localSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        if (this.peerSupportedSignAlgs != null) {
            return (String[])this.peerSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    public String toString() {
        return "[Session-" + this.sessionCount + ", " + this.getCipherSuite() + "]";
    }

    protected void finalize() throws Throwable {
        String[] names = this.getValueNames();
        for (int i = 0; i < names.length; ++i) {
            this.removeValue(names[i]);
        }
    }
}

