/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.sun.security.ssl.extension.RenegotiationInfoExtension;
import cfca.sadk.tls.sun.security.ssl.extension.ServerNameExtension;
import cfca.sadk.tls.sun.security.ssl.extension.SignatureAlgorithmsExtension;
import cfca.sadk.tls.sun.security.ssl.extension.SupportedEllipticCurvesExtension;
import cfca.sadk.tls.sun.security.ssl.extension.SupportedEllipticPointFormatsExtension;
import cfca.sadk.tls.sun.security.ssl.extension.UnknownExtension;
import cfca.sadk.tls.util.DataHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

public final class HelloExtensions {
    private List<HelloExtension> extensions = Collections.emptyList();
    private int encodedLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void decodedFrom(HandshakeInStream in) throws IOException {
        int len = in.getInt16();
        this.extensions = new ArrayList<HelloExtension>();
        this.encodedLength = len + 2;
        ExtensionType extType = null;
        HelloExtension extension = null;
        int type = 0;
        int extlen = 0;
        while (len > 0) {
            block15: {
                type = in.getInt16();
                extlen = in.getInt16();
                try {
                    switch (ExtensionType.valueOf(type)) {
                        case EXT_SERVER_NAME: {
                            extension = new ServerNameExtension(in, extlen);
                            break;
                        }
                        case EXT_SIGNATURE_ALGORITHMS: {
                            extension = new SignatureAlgorithmsExtension(in, extlen);
                            break;
                        }
                        case EXT_ELLIPTIC_CURVES: {
                            extension = new SupportedEllipticCurvesExtension(in, extlen);
                            break;
                        }
                        case EXT_EC_POINT_FORMATS: {
                            extension = new SupportedEllipticPointFormatsExtension(in, extlen);
                            break;
                        }
                        case EXT_RENEGOTIATION_INFO: {
                            extension = new RenegotiationInfoExtension(in, extlen);
                            break;
                        }
                        default: {
                            extension = new UnknownExtension(in, extlen, extType);
                        }
                    }
                    if (extension == null) break block15;
                    this.extensions.add(extension);
                }
                catch (Exception e) {
                    if (extension != null) {
                        this.extensions.add(extension);
                    }
                    len -= extlen + 4;
                    continue;
                    catch (Throwable throwable) {
                        if (extension != null) {
                            this.extensions.add(extension);
                        }
                        len -= extlen + 4;
                        throw throwable;
                    }
                }
            }
            len -= extlen + 4;
        }
        if (len != 0) {
            throw new SSLProtocolException("Error parsing extensions: extra data");
        }
    }

    public List<HelloExtension> list() {
        return this.extensions;
    }

    public void add(HelloExtension ext) {
        if (ext != null) {
            if (this.extensions.isEmpty()) {
                this.extensions = new ArrayList<HelloExtension>();
            }
            this.extensions.add(ext);
            this.encodedLength = -1;
        }
    }

    public HelloExtension get(ExtensionType type) {
        for (HelloExtension ext : this.extensions) {
            if (ext.type != type) continue;
            return ext;
        }
        return null;
    }

    public int length() {
        if (this.encodedLength >= 0) {
            return this.encodedLength;
        }
        if (this.extensions.isEmpty()) {
            this.encodedLength = 0;
        } else {
            this.encodedLength = 2;
            for (HelloExtension ext : this.extensions) {
                this.encodedLength += ext.length();
            }
        }
        return this.encodedLength;
    }

    public byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        if (encoded.length != 0) {
            DataHelper.write((short)(encoded.length - 2), encoded, 0);
            int offset = 2;
            for (HelloExtension ext : this.extensions) {
                offset += DataHelper.write(ext.getEncoded(), encoded, offset);
            }
        }
        return encoded;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (HelloExtension extension : this.extensions) {
            builder.append('\n').append(extension);
        }
        return builder.toString();
    }
}

