/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.util.DataHelper;
import java.io.IOException;
import javax.net.ssl.SSLProtocolException;

public final class ServerNameExtension
extends HelloExtension {
    static final int NAME_HEADER_LENGTH = 3;
    private int listLength;

    public ServerNameExtension() throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        this.listLength = 0;
    }

    ServerNameExtension(HandshakeInStream in, int len) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        int remains = len;
        if (len >= 2) {
            this.listLength = in.getInt16();
            if (this.listLength == 0 || this.listLength + 2 != len) {
                throw new SSLProtocolException("Invalid " + (Object)((Object)this.type) + " extension");
            }
            remains -= 2;
            while (remains > 0) {
                in.getInt8();
                byte[] nameEncoded = in.getBytes16();
                remains -= nameEncoded.length + 3;
            }
        } else if (len == 0) {
            this.listLength = 0;
        }
        if (remains != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    @Override
    final int length() {
        return this.listLength == 0 ? 4 : 6 + this.listLength;
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        DataHelper.write((short)this.type.id, encoded, 0);
        if (this.listLength == 0) {
            DataHelper.write((short)0, encoded, 2);
        }
        return encoded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension ").append((Object)this.type);
        builder.append(", server_name: none");
        return builder.toString();
    }
}

