/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.util.DataHelper;
import cfca.sadk.tls.util.Hex;
import java.io.IOException;

final class UnknownExtension
extends HelloExtension {
    private final byte[] data;

    UnknownExtension(HandshakeInStream in, int length, ExtensionType type) throws IOException {
        super(type);
        this.data = new byte[length];
        if (length != 0) {
            in.read(this.data);
        }
    }

    @Override
    final int length() {
        return 4 + (this.data == null ? 0 : this.data.length);
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        int dataLength = encoded.length - 4;
        DataHelper.write((short)this.type.id, encoded, 0);
        DataHelper.write((short)dataLength, encoded, 2);
        DataHelper.write(this.data, encoded, 4);
        return encoded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UnknownExtension ").append((Object)this.type);
        builder.append(", data: ");
        if (this.data == null) {
            builder.append("null");
        } else {
            builder.append("0x").append(Hex.hexify(this.data));
        }
        return builder.toString();
    }
}

