/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.sun.security.ssl.manager.LRULinkedHashMap;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import cfca.sadk.tls.util.Loggings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class GMHosts {
    public static final GMHosts INSTANCE = new GMHosts();
    private final Map<String, String> nameToAddr;
    private final Map<String, String> addrToName;

    private GMHosts() {
        int cacheSize = GMSSLConstants.cacheSizeOfHosts;
        this.nameToAddr = Collections.synchronizedMap(new LRULinkedHashMap(cacheSize));
        this.addrToName = Collections.synchronizedMap(new LRULinkedHashMap(cacheSize));
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        File file;
        String path = GMSSLConstants.hostnamesFile;
        Loggings.ENVIRONMENT.info("hostnames: {}", (Object)path);
        if (path != null && path.length() != 0 && (file = new File(path)).exists() && file.isFile()) {
            String absolutePath = file.getAbsolutePath();
            Loggings.ENVIRONMENT.info("hostnames: {}", (Object)absolutePath);
            Properties properties = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                Loggings.ENVIRONMENT.info("hostnames load from start: {}", (Object)absolutePath);
                properties.load(in);
                Loggings.ENVIRONMENT.info("hostnames={}", (Object)properties);
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String name = (String)keys.nextElement();
                    String addr = properties.getProperty(name);
                    if (name == null || addr == null) continue;
                    this.nameToAddr.put(name, addr);
                    this.addrToName.put(addr, name);
                }
                Loggings.ENVIRONMENT.info("hostnames load from end: {}", (Object)absolutePath);
            }
            catch (Exception e) {
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {
                        Loggings.ENVIRONMENT.info("hostnames close failed: {}", (Object)absolutePath, (Object)e);
                    }
                }
            }
        }
    }

    public String getHost(String addr) {
        return this.addrToName.get(addr);
    }

    public InetAddress getAddr(String host) {
        InetAddress addrResult = null;
        if (host != null) {
            try {
                String addr = this.nameToAddr.get(host);
                String hostname = addr != null ? addr : host;
                long strTime = System.currentTimeMillis();
                addrResult = InetAddress.getByName(hostname);
                long runTime = System.currentTimeMillis() - strTime;
                if (runTime > 1000L) {
                    Loggings.ERROR.warn("hostname-{} ByName runtime={}", (Object)host, (Object)runTime);
                } else {
                    Loggings.INFO.info("hostname-{} ByName runtime={}", (Object)host, (Object)runTime);
                }
            }
            catch (UnknownHostException e) {
                Loggings.ERROR.error("hostname-{} ByName failed", (Object)host);
                addrResult = null;
            }
        }
        return addrResult;
    }

    public SocketAddress getAddr(String host, int port) throws UnknownHostException {
        InetAddress addr;
        InetSocketAddress socketAddress = null;
        socketAddress = host == null ? new InetSocketAddress(InetAddress.getByName(null), port) : ((addr = this.getAddr(host)) == null ? new InetSocketAddress(host, port) : new InetSocketAddress(addr, port));
        return socketAddress;
    }
}

