/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.sun.security.ssl.manager.GMX509TrustManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public abstract class GMX509TrustManagerFactory
extends TrustManagerFactorySpi {
    private X509TrustManager trustManager = null;
    private boolean isInitialized = false;

    GMX509TrustManagerFactory() {
    }

    @Override
    protected void engineInit(KeyStore keystore) throws KeyStoreException {
        if (keystore == null) {
            throw new KeyStoreException("missing trust store");
        }
        this.trustManager = this.getInstance(keystore);
        this.isInitialized = true;
    }

    abstract X509TrustManager getInstance(KeyStore var1) throws KeyStoreException;

    abstract X509TrustManager getInstance(ManagerFactoryParameters var1) throws InvalidAlgorithmParameterException;

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.trustManager = this.getInstance(spec);
        this.isInitialized = true;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.trustManager};
    }

    public static final class GMPKIXFactory
    extends GMX509TrustManagerFactory {
        @Override
        X509TrustManager getInstance(KeyStore keystore) throws KeyStoreException {
            return new GMX509TrustManager(keystore);
        }

        @Override
        X509TrustManager getInstance(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
            if (spec == null) {
                throw new InvalidAlgorithmParameterException("Parameters must be not null");
            }
            if (!(spec instanceof CertPathTrustManagerParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be CertPathTrustManagerParameters");
            }
            CertPathParameters params = ((CertPathTrustManagerParameters)spec).getParameters();
            if (params == null) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be not null");
            }
            if (!(params instanceof PKIXBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be PKIXBuilderParameters");
            }
            return new GMX509TrustManager((PKIXBuilderParameters)params);
        }
    }
}

