/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

public final class CertificateMsg
extends HandshakeMessage {
    private X509Certificate[] chain;
    private List<byte[]> encodedChain;
    private int messageLength;

    public CertificateMsg(X509Certificate[] chain) {
        this.chain = chain;
    }

    public CertificateMsg(HandshakeInStream in) throws IOException {
        int chainLen = in.getInt24();
        ArrayList<Certificate> v = new ArrayList<Certificate>(4);
        CertificateFactory cf = null;
        while (chainLen > 0) {
            byte[] cert = in.getBytes24();
            chainLen -= 3 + cert.length;
            try {
                if (cf == null) {
                    cf = JSSEJCE.getCertificateFactory();
                }
                Certificate pcert = cf.generateCertificate(new ByteArrayInputStream(cert));
                v.add(pcert);
            }
            catch (CertificateException e) {
                throw (SSLProtocolException)new SSLProtocolException(e.getMessage()).initCause(e);
            }
        }
        this.chain = v.toArray(new X509Certificate[v.size()]);
    }

    @Override
    public int messageType() {
        return 11;
    }

    @Override
    int messageLength() {
        if (this.encodedChain == null) {
            this.messageLength = 3;
            this.encodedChain = new ArrayList<byte[]>(this.chain.length);
            try {
                byte[] encoding = null;
                for (X509Certificate cert : this.chain) {
                    encoding = cert.getEncoded();
                    this.encodedChain.add(encoding);
                    this.messageLength += encoding.length + 3;
                }
            }
            catch (CertificateEncodingException e) {
                this.encodedChain = null;
                throw new RuntimeException("Could not encode certificates", e);
            }
        }
        return this.messageLength;
    }

    @Override
    void send(HandshakeOutStream out) throws IOException {
        out.putInt24(this.messageLength() - 3);
        for (byte[] cert : this.encodedChain) {
            out.putBytes24(cert);
        }
    }

    public X509Certificate[] chain() {
        return this.chain;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append("*** Certificate chain");
        for (int i = 0; i < this.chain.length; ++i) {
            builder.append('\n');
            builder.append("chain [").append(i).append("] = ").append(this.chain[i]);
        }
        builder.append("\n***");
        return builder.toString();
    }
}

