/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.DistinguishedName;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.KeyExchangeAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;

public final class CertificateRequest
extends HandshakeMessage {
    public static final int cct_ecdsa_sign = 64;
    public static final int cct_ibc_params = 80;
    private static final byte[] TYPES_ECC = new byte[]{64};
    public byte[] types;
    DistinguishedName[] authorities;
    ProtocolVersion protocolVersion;
    private Collection<SignatureAndHashAlgorithm> algorithms;

    public CertificateRequest(X509Certificate[] ca, KeyExchangeAlgorithm keyExchange, Collection<SignatureAndHashAlgorithm> signAlgs, ProtocolVersion protocolVersion) throws IOException {
        this.protocolVersion = protocolVersion;
        this.authorities = new DistinguishedName[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            X500Principal x500Principal = ca[i].getSubjectX500Principal();
            this.authorities[i] = new DistinguishedName(x500Principal);
        }
        this.types = TYPES_ECC;
        if (protocolVersion.isChinaTLS11()) {
            this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
        }
    }

    public CertificateRequest(HandshakeInStream in, ProtocolVersion protocolVersion) throws IOException {
        int len;
        DistinguishedName dn;
        this.protocolVersion = protocolVersion;
        this.types = in.getBytes8();
        if (protocolVersion.isChinaTLS11()) {
            this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
        }
        ArrayList<DistinguishedName> v = new ArrayList<DistinguishedName>();
        for (len = in.getInt16(); len >= 3; len -= dn.length()) {
            dn = new DistinguishedName(in);
            v.add(dn);
        }
        if (len != 0) {
            throw new SSLProtocolException("Bad CertificateRequest DN length");
        }
        this.authorities = v.toArray(new DistinguishedName[v.size()]);
    }

    public X500Principal[] getAuthorities() throws IOException {
        X500Principal[] ret = new X500Principal[this.authorities.length];
        for (int i = 0; i < this.authorities.length; ++i) {
            ret[i] = this.authorities[i].getX500Principal();
        }
        return ret;
    }

    public Collection<SignatureAndHashAlgorithm> getSignAlgorithms() {
        return this.algorithms;
    }

    @Override
    public int messageType() {
        return 13;
    }

    @Override
    int messageLength() {
        int len = 1 + this.types.length + 2;
        for (int i = 0; i < this.authorities.length; ++i) {
            len += this.authorities[i].length();
        }
        return len;
    }

    @Override
    void send(HandshakeOutStream out) throws IOException {
        int i;
        out.putBytes8(this.types);
        int len = 0;
        for (i = 0; i < this.authorities.length; ++i) {
            len += this.authorities[i].length();
        }
        out.putInt16(len);
        for (i = 0; i < this.authorities.length; ++i) {
            this.authorities[i].write(out);
        }
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append("*** CertificateRequest");
        builder.append("Cert Types: ");
        for (i = 0; i < this.types.length; ++i) {
            switch (this.types[i]) {
                case 64: {
                    builder.append("SM2");
                    break;
                }
                case 80: {
                    builder.append("IBC");
                    break;
                }
                default: {
                    builder.append("Type-" + (this.types[i] & 0xFF));
                }
            }
            if (i == this.types.length - 1) continue;
            builder.append(", ");
        }
        builder.append('\n');
        builder.append("Cert Authorities:");
        if (this.authorities.length == 0) {
            builder.append('\n');
            builder.append("<Empty>");
        } else {
            for (i = 0; i < this.authorities.length; ++i) {
                builder.append(this.authorities[i]);
            }
        }
        builder.append("\n***");
        return builder.toString();
    }
}

