/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeType;
import cfca.sadk.tls.util.Hex;
import java.io.IOException;
import javax.net.ssl.SSLException;

public abstract class HandshakeMessage
implements HandshakeType {
    HandshakeMessage() {
    }

    public final void write(HandshakeOutStream out) throws IOException {
        int len = this.messageLength();
        if (len >= 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + len);
        }
        out.write(this.messageType());
        out.putInt24(len);
        this.send(out);
    }

    public abstract int messageType();

    abstract int messageLength();

    abstract void send(HandshakeOutStream var1) throws IOException;

    final void builderAppend(StringBuilder builder, String prefix, byte[] data) {
        if (builder == null) {
            return;
        }
        builder.append(prefix);
        if (data == null) {
            builder.append("null");
        } else {
            builder.append("0x").append(Hex.hexify(data));
        }
        builder.append("\n ");
    }
}

