/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.tls.pure.ISignature;
import cfca.sadk.tls.pure.impl.SM2Helper;
import cfca.sadk.tls.pure.impl.SM2Signature;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.ECDHCrypt;
import cfca.sadk.tls.sun.security.ssl.sec.ECDHParams;
import cfca.sadk.tls.sun.security.ssl.sec.ECNamedCurve;
import cfca.sadk.tls.sun.security.ssl.sec.SSLCredentials;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Collection;
import javax.net.ssl.SSLKeyException;

public abstract class ServerKeyExchange
extends HandshakeMessage {
    @Override
    public final int messageType() {
        return 12;
    }

    public static final class SKESM2DHE
    extends ServerKeyExchange {
        private int curveType = 3;
        private ISignature signature;
        private byte[] ecParametersBytes;
        private byte[] pointBytes;
        private byte[] signatureBytes;
        private ECParameterSpec ecParameters;
        private ECPublicKey publicKey;

        public SKESM2DHE(ECDHCrypt ecdh, PrivateKey signingKey, RandomCookie clientNance, RandomCookie serverNance, SecureRandom random, SignatureAndHashAlgorithm signAlgorithm, ProtocolVersion protocolVersion) throws SecurityException {
            this.curveType = 3;
            this.publicKey = ecdh.getPublicKey();
            this.ecParameters = this.publicKey.getParameters();
            this.ecParametersBytes = ECDHParams.getECParametersBytes(this.ecParameters, this.curveType);
            this.pointBytes = ECNamedCurve.encodePoint(this.publicKey.getQ(), this.ecParameters.getCurve());
            this.signature = new SM2Signature();
            this.signature.initSign(signingKey);
            this.signatureUpdate(clientNance.random, serverNance.random);
            this.signatureBytes = this.signature.sign();
        }

        public SKESM2DHE(HandshakeInStream in, PublicKey signingKey, RandomCookie clientNance, RandomCookie serverNance, Collection<SignatureAndHashAlgorithm> localSupportedSignAlgs, ProtocolVersion protocolVersion) throws IOException, SecurityException {
            this.curveType = in.getInt8();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.ecParameters = ECDHParams.readECParameters(out, this.curveType, in);
            this.ecParametersBytes = out.toByteArray();
            this.pointBytes = in.getBytes8();
            this.publicKey = SM2Helper.formPublicKey(this.pointBytes);
            this.signatureBytes = in.getBytes16();
            this.signature = new SM2Signature();
            this.signature.initVerify(signingKey);
            this.signatureUpdate(clientNance.random, serverNance.random);
            if (!this.signature.verify(this.signatureBytes)) {
                throw new SSLKeyException("Invalid signature on ECDH server key exchange message");
            }
        }

        public ECPublicKey getEphemeralPublicKey() {
            return this.publicKey;
        }

        final void signatureUpdate(byte[] cnonce, byte[] snonce) throws SecurityException {
            this.signature.update(cnonce);
            this.signature.update(snonce);
            this.signature.update(this.ecParametersBytes);
            this.signature.update((byte)this.pointBytes.length);
            this.signature.update(this.pointBytes);
        }

        @Override
        int messageLength() {
            int sigLen = 0;
            if (this.signatureBytes != null) {
                sigLen = 2 + this.signatureBytes.length;
            }
            return this.ecParametersBytes.length + 1 + this.pointBytes.length + sigLen;
        }

        @Override
        void send(HandshakeOutStream out) throws IOException {
            out.write(this.ecParametersBytes);
            out.putBytes8(this.pointBytes);
            out.putBytes16(this.signatureBytes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            builder.append("*** ECDH ServerKeyExchange");
            builder.append('\n');
            builder.append("Server key: ").append(this.publicKey);
            builder.append("\n***");
            return builder.toString();
        }
    }

    public static final class SKEPKEA
    extends ServerKeyExchange {
        private ISignature signature = new SM2Signature();
        private byte[] signatureBytes;

        public SKEPKEA(String sigAlg, SSLCredentials signer, RandomCookie clientNance, RandomCookie serverNance, Certificate encryptionCert) throws Exception {
            this.signature.initSign(signer.privateKey);
            this.signatureUpdate(clientNance, serverNance, encryptionCert);
            this.signatureBytes = this.signature.sign();
        }

        public SKEPKEA(String sigAlg, HandshakeInStream in) throws Exception {
            this.signatureBytes = in.getBytes16();
        }

        final void signatureUpdate(RandomCookie clientNance, RandomCookie serverNance, Certificate encryptionCert) throws Exception {
            byte[] certBytes = encryptionCert.getEncoded();
            int certLength = certBytes.length;
            this.signature.update(clientNance.random);
            this.signature.update(serverNance.random);
            this.signature.update((byte)(certLength >> 16));
            this.signature.update((byte)(certLength >> 8));
            this.signature.update((byte)certLength);
            this.signature.update(certBytes);
        }

        public final boolean verify(SSLCredentials signer, RandomCookie clientNance, RandomCookie serverNance, Certificate encryptionCert) throws Exception {
            this.signature.initVerify(signer.publicKey);
            this.signatureUpdate(clientNance, serverNance, encryptionCert);
            return this.signature.verify(this.signatureBytes);
        }

        @Override
        int messageLength() {
            return 2 + this.signatureBytes.length;
        }

        @Override
        void send(HandshakeOutStream out) throws IOException {
            out.putBytes16(this.signatureBytes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            builder.append("***  ServerKeyExchangePKEA SM2");
            builder.append("\n***");
            return builder.toString();
        }
    }
}

