/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretKey;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretParameters;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfGenerator;
import java.security.DigestException;
import java.security.ProviderException;
import java.util.Arrays;
import javax.crypto.SecretKey;

class TlsMasterSecretGenerator
implements TlsKeyMaterialsConstants {
    static final TlsMasterSecretGenerator INSTANCE = new TlsMasterSecretGenerator();
    private static final int[] versions = new int[]{ProtocolVersion.TLS11SM.version};

    private TlsMasterSecretGenerator() {
    }

    static boolean hasVersion(int version) {
        return Arrays.binarySearch(versions, version) >= 0;
    }

    TlsMasterSecretKey generateMasterKey(TlsMasterSecretParameters params) throws CryptoException {
        int premasterMinor;
        int premasterMajor;
        int protocolVersion = this.checkParameters(params);
        if (protocolVersion != ProtocolVersion.TLS11SM.version) {
            throw new CryptoException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
        }
        SecretKey premasterKey = params.getPremasterSecret();
        byte[] premaster = premasterKey.getEncoded();
        if ("TlsPremasterSecret".equals(premasterKey.getAlgorithm())) {
            premasterMajor = premaster[0] & 0xFF;
            premasterMinor = premaster[1] & 0xFF;
        } else {
            premasterMajor = -1;
            premasterMinor = -1;
        }
        int mastkeyLength = 48;
        try {
            byte[] clientRandom = params.getClientRandom();
            byte[] serverRandom = params.getServerRandom();
            byte[] seed = TlsKeyMaterialsTools.concat(clientRandom, serverRandom);
            byte[] master = TlsPrfGenerator.doTLS12PRF(premaster, LABEL_MASTER_SECRET, seed, 48, params.getPrfHashParameters());
            return new TlsMasterSecretKey(master, premasterMajor, premasterMinor);
        }
        catch (DigestException e) {
            throw new ProviderException(e);
        }
    }

    private int checkParameters(TlsMasterSecretParameters params) throws CryptoException {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsMasterSecretParameters"));
        }
        if (params.getPremasterSecret() == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsMasterSecretParameters#PremasterSecret"));
        }
        if (!"RAW".equals(params.getPremasterSecret().getFormat())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeRAW", "TlsMasterSecretParameters#PremasterSecret"));
        }
        int protocolVersion = params.getMajorVersion() << 8 | params.getMinorVersion();
        if (!TlsMasterSecretGenerator.hasVersion(protocolVersion)) {
            throw new CryptoException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
        }
        return protocolVersion;
    }
}

