/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.IDigest;
import cfca.sadk.tls.pure.impl.SM3Digest;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfParameters;
import java.security.DigestException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class TlsPrfGenerator
implements TlsKeyMaterialsConstants {
    static final TlsPrfGenerator INSTANCE = new TlsPrfGenerator();
    private static final byte[] B0 = new byte[0];
    private static final byte[] HMAC_ipad64 = TlsKeyMaterialsTools.genPad((byte)54, 64);
    private static final byte[] HMAC_ipad128 = TlsKeyMaterialsTools.genPad((byte)54, 128);
    private static final byte[] HMAC_opad64 = TlsKeyMaterialsTools.genPad((byte)92, 64);
    private static final byte[] HMAC_opad128 = TlsKeyMaterialsTools.genPad((byte)92, 128);

    private TlsPrfGenerator() {
    }

    final SecretKey generateKey(TlsPrfParameters params) throws CryptoException {
        this.checkParameters(params);
        SecretKey key = params.getSecret();
        byte[] secret = key == null ? null : key.getEncoded();
        try {
            byte[] labelBytes = params.getLabel().getBytes("UTF8");
            byte[] seedBytes = params.getSeed();
            int outputLength = params.getOutputLength();
            byte[] prfBytes = TlsPrfGenerator.doTLS12PRF(secret, labelBytes, seedBytes, outputLength, params.hashPRF());
            return new SecretKeySpec(prfBytes, "TlsPrf");
        }
        catch (Exception e) {
            throw new CryptoException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.generateKey"), e);
        }
    }

    private void checkParameters(TlsPrfParameters params) {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsPrfParameters"));
        }
        if (!"RAW".equals(params.getSecret().getFormat())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeRAW", "TlsPrfParameters#Secret"));
        }
        if (params.getLabel() == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsPrfParameters#Label"));
        }
    }

    static byte[] doTLS12PRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, HashPRF prfHash) throws CryptoException, DigestException {
        byte[] opad;
        byte[] ipad;
        if (prfHash != HashPRF.SM3) {
            throw new CryptoException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "prfHash"));
        }
        SM3Digest mdPRF = new SM3Digest();
        int mdPRFLen = prfHash.prfHashLength;
        int mdPRFBlockSize = prfHash.prfBlockSize;
        if (secret == null) {
            secret = B0;
        }
        if (secret.length > mdPRFBlockSize) {
            secret = mdPRF.digest(secret);
        }
        byte[] output = new byte[outputLength];
        switch (mdPRFBlockSize) {
            case 64: {
                ipad = (byte[])HMAC_ipad64.clone();
                opad = (byte[])HMAC_opad64.clone();
                break;
            }
            case 128: {
                ipad = (byte[])HMAC_ipad128.clone();
                opad = (byte[])HMAC_opad128.clone();
                break;
            }
            default: {
                throw new CryptoException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.unexpectedBlockSize"));
            }
        }
        TlsPrfGenerator.expand(mdPRF, mdPRFLen, secret, 0, secret.length, labelBytes, seed, output, ipad, opad);
        return output;
    }

    private static void expand(IDigest digest, int hmacSize, byte[] secret, int secOff, int secLen, byte[] label, byte[] seed, byte[] output, byte[] pad1, byte[] pad2) throws CryptoException, DigestException {
        int k;
        for (int i = 0; i < secLen; ++i) {
            int n = i;
            pad1[n] = (byte)(pad1[n] ^ secret[i + secOff]);
            int n2 = i;
            pad2[n2] = (byte)(pad2[n2] ^ secret[i + secOff]);
        }
        byte[] tmp = new byte[hmacSize];
        byte[] aBytes = null;
        int ofs = 0;
        for (int remaining = output.length; remaining > 0; remaining -= k) {
            digest.update(pad1);
            if (aBytes == null) {
                digest.update(label);
                digest.update(seed);
            } else {
                digest.update(aBytes);
            }
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            if (aBytes == null) {
                aBytes = new byte[hmacSize];
            }
            digest.digest(aBytes, 0, hmacSize);
            digest.update(pad1);
            digest.update(aBytes);
            digest.update(label);
            digest.update(seed);
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            digest.digest(tmp, 0, hmacSize);
            k = Math.min(hmacSize, remaining);
            for (int i = 0; i < k; ++i) {
                int n = ofs++;
                output[n] = (byte)(output[n] ^ tmp[i]);
            }
        }
    }
}

