/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.pure.SymEncryption;
import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.ConnectionKeys;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBulk;
import cfca.sadk.tls.sun.security.ssl.sec.CipherMode;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import cfca.sadk.tls.sun.security.ssl.sec.MAC;
import cfca.sadk.tls.sun.security.ssl.sec.SecureRandoms;
import cfca.sadk.tls.util.Hex;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class CipherBox {
    public static final CipherBox NULL = new CipherBox();
    private final ProtocolVersion protocolVersion;
    private final SymEncryption cipher;
    private SecureRandom random;
    private final int mode;
    private final CipherMode cipherType;
    private static final Hashtable<Integer, IvParameterSpec> masks = new Hashtable(5);

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
        this.cipherType = CipherMode.STREAM;
        this.mode = 1;
        this.random = null;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherBulk bulkCipher, SecretKey key, IvParameterSpec iv, SecureRandom random, boolean encrypt) throws NoSuchAlgorithmException {
        try {
            this.protocolVersion = protocolVersion;
            this.cipher = CryptoFactory.singleton().getEncryption(bulkCipher.transformation);
            this.mode = encrypt ? 1 : 2;
            this.random = random == null ? SecureRandoms.newSecure() : random;
            this.cipherType = bulkCipher.cipherType;
            if (iv == null && bulkCipher.ivSize != 0 && this.mode == 2 && protocolVersion.isTLS11()) {
                iv = CipherBox.getFixedMask(bulkCipher.ivSize);
            }
            this.cipher.init(this.mode, key, iv, this.random);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchAlgorithmException("Could not create cipher " + (Object)((Object)bulkCipher), e);
        }
        catch (ExceptionInInitializerError e) {
            throw new NoSuchAlgorithmException("Could not create cipher " + (Object)((Object)bulkCipher), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherBox newCipher(ProtocolVersion version, CipherBulk bulk, ConnectionKeys k, SecureRandom random, boolean encrypt) throws NoSuchAlgorithmException {
        try {
            CipherBox box;
            if (!bulk.allowed) {
                throw new NoSuchAlgorithmException("Unsupported cipher " + (Object)((Object)bulk));
            }
            CipherBox cipherBox = box = CipherBulk.B_NULL == bulk ? NULL : new CipherBox(version, bulk, k.writeKey, k.writeIV, random, encrypt);
            return cipherBox;
        }
        finally {
            k.cleanWriteKey();
        }
    }

    private static IvParameterSpec getFixedMask(int ivSize) {
        IvParameterSpec iv = masks.get(ivSize);
        if (iv == null) {
            iv = new IvParameterSpec(new byte[ivSize]);
            masks.put(ivSize, iv);
        }
        return iv;
    }

    public int encrypt(byte[] buf, int offset, int len) {
        if (this.cipher == null) {
            return len;
        }
        try {
            int newLen;
            int blockSize = this.cipher.getBlockSize();
            if (this.cipherType == CipherMode.BLOCKS) {
                len = CipherBox.addPadding(buf, offset, len, blockSize);
            }
            if (Debugger.datashaker.isDebugEnabled()) {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\nPadded plaintext before ENCRYPTION:  len =").append(len);
                    builder.append('\n');
                    builder.append((CharSequence)Hex.dump("", buf, offset, len));
                    Debugger.datashaker.debug(builder.toString());
                    builder = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((newLen = this.cipher.update(buf, offset, len, buf, offset)) != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return newLen;
        }
        catch (SecurityException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    public int encrypt(ByteBuffer bb, int outLimit) {
        int newLen;
        int len = bb.remaining();
        if (this.cipher == null) {
            bb.position(bb.limit());
            return len;
        }
        int pos = bb.position();
        int blockSize = this.cipher.getBlockSize();
        if (this.cipherType == CipherMode.BLOCKS) {
            len = CipherBox.addPadding(bb, blockSize);
            bb.position(pos);
        }
        if (Debugger.datashaker.isDebugEnabled()) {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("\nPadded plaintext before ENCRYPTION:  len =").append(len);
                builder.append('\n');
                builder.append((CharSequence)Hex.dump("", bb.duplicate()));
                Debugger.datashaker.debug(builder.toString());
                builder = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ByteBuffer dup = bb.duplicate();
        try {
            newLen = this.cipher.update(dup, bb);
        }
        catch (SecurityException sbe) {
            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
        }
        if (bb.position() != dup.position()) {
            throw new RuntimeException("bytebuffer padding error");
        }
        if (newLen != len) {
            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
        }
        return newLen;
    }

    public int decrypt(byte[] buf, int offset, int len, int tagLen) throws BadPaddingException {
        if (this.cipher == null) {
            return len;
        }
        try {
            int newLen = this.cipher.update(buf, offset, len, buf, offset);
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (Debugger.datashaker.isDebugEnabled()) {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\nPadded plaintext after DECRYPTION:  len =").append(len);
                    builder.append('\n');
                    builder.append((CharSequence)Hex.dump("", buf, offset, len));
                    Debugger.datashaker.debug(builder.toString());
                    builder = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.cipherType == CipherMode.BLOCKS) {
                int blockSize = this.cipher.getBlockSize();
                newLen = CipherBox.removePadding(buf, offset, newLen, tagLen, blockSize, this.protocolVersion);
                if (this.protocolVersion.isTLS11() && newLen < blockSize) {
                    throw new BadPaddingException("invalid explicit IV");
                }
            }
            return newLen;
        }
        catch (SecurityException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    public int decrypt(ByteBuffer bb, int tagLen) throws BadPaddingException {
        int len = bb.remaining();
        if (this.cipher == null) {
            bb.position(bb.limit());
            return len;
        }
        try {
            int pos = bb.position();
            ByteBuffer dup = bb.duplicate();
            int newLen = this.cipher.update(dup, bb);
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            bb.limit(pos + newLen);
            if (Debugger.datashaker.isDebugEnabled()) {
                try {
                    ByteBuffer data = (ByteBuffer)bb.duplicate().position(pos);
                    StringBuilder builder = new StringBuilder();
                    builder.append("\nPadded plaintext after DECRYPTION:  len =").append(len);
                    builder.append('\n');
                    builder.append((CharSequence)Hex.dump("", data.array(), data.position(), data.remaining()));
                    Debugger.datashaker.debug(builder.toString());
                    builder = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.cipherType == CipherMode.BLOCKS) {
                int blockSize = this.cipher.getBlockSize();
                bb.position(pos);
                newLen = CipherBox.removePadding(bb, tagLen, blockSize, this.protocolVersion);
                if (this.protocolVersion.isTLS11()) {
                    if (newLen < blockSize) {
                        throw new BadPaddingException("invalid explicit IV");
                    }
                    bb.position(bb.limit());
                }
            }
            return newLen;
        }
        catch (SecurityException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    private static int addPadding(byte[] buf, int offset, int len, int blockSize) {
        int newlen = len + 1;
        if (newlen % blockSize != 0) {
            newlen += blockSize - 1;
            newlen -= newlen % blockSize;
        }
        int pad = newlen - len;
        if (buf.length < newlen + offset) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        offset += len;
        for (int i = 0; i < pad; ++i) {
            buf[offset++] = (byte)(pad - 1);
        }
        return newlen;
    }

    private static int addPadding(ByteBuffer bb, int blockSize) {
        int len = bb.remaining();
        int offset = bb.position();
        int newlen = len + 1;
        if (newlen % blockSize != 0) {
            newlen += blockSize - 1;
            newlen -= newlen % blockSize;
        }
        int pad = newlen - len;
        bb.limit(newlen + offset);
        offset += len;
        for (int i = 0; i < pad; ++i) {
            bb.put(offset++, (byte)(pad - 1));
        }
        bb.position(offset);
        bb.limit(offset);
        return newlen;
    }

    private static int[] checkPadding(byte[] buf, int offset, int len, byte pad) {
        if (len <= 0) {
            throw new RuntimeException("padding len must be positive");
        }
        int[] results = new int[]{0, 0};
        int i = 0;
        while (i <= 256) {
            for (int j = 0; j < len && i <= 256; ++j, ++i) {
                if (buf[offset + j] != pad) {
                    results[0] = results[0] + 1;
                    continue;
                }
                results[1] = results[1] + 1;
            }
        }
        return results;
    }

    private static int[] checkPadding(ByteBuffer bb, byte pad) {
        if (!bb.hasRemaining()) {
            throw new RuntimeException("hasRemaining() must be positive");
        }
        int[] results = new int[]{0, 0};
        bb.mark();
        int i = 0;
        while (i <= 256) {
            while (bb.hasRemaining() && i <= 256) {
                if (bb.get() != pad) {
                    results[0] = results[0] + 1;
                } else {
                    results[1] = results[1] + 1;
                }
                ++i;
            }
            bb.reset();
        }
        return results;
    }

    private static int removePadding(byte[] buf, int offset, int len, int tagLen, int blockSize, ProtocolVersion protocolVersion) throws BadPaddingException {
        int padOffset = offset + len - 1;
        int padLen = buf[padOffset] & 0xFF;
        int newLen = len - (padLen + 1);
        if (newLen - tagLen < 0) {
            CipherBox.checkPadding(buf, offset, len, (byte)(padLen & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + padLen);
        }
        int[] results = CipherBox.checkPadding(buf, offset + newLen, padLen + 1, (byte)(padLen & 0xFF));
        if (results[0] != 0) {
            throw new BadPaddingException("Invalid TLS padding data");
        }
        return newLen;
    }

    private static int removePadding(ByteBuffer bb, int tagLen, int blockSize, ProtocolVersion protocolVersion) throws BadPaddingException {
        int offset;
        int padOffset;
        int padLen;
        int len = bb.remaining();
        int newLen = len - ((padLen = bb.get(padOffset = (offset = bb.position()) + len - 1) & 0xFF) + 1);
        if (newLen - tagLen < 0) {
            CipherBox.checkPadding(bb.duplicate(), (byte)(padLen & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + padLen);
        }
        int[] results = CipherBox.checkPadding((ByteBuffer)bb.duplicate().position(offset + newLen), (byte)(padLen & 0xFF));
        if (results[0] != 0) {
            throw new BadPaddingException("Invalid TLS padding data");
        }
        bb.position(offset + newLen);
        bb.limit(offset + newLen);
        return newLen;
    }

    public void dispose() {
        try {
            if (this.cipher != null) {
                this.cipher.doFinal();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCBCMode() {
        return this.cipherType == CipherMode.BLOCKS;
    }

    public boolean isNullCipher() {
        return this.cipher == null;
    }

    public int getExplicitNonceSize() {
        switch (this.cipherType) {
            case BLOCKS: {
                if (!this.protocolVersion.isTLS11()) break;
                return this.cipher.getBlockSize();
            }
        }
        return 0;
    }

    public int applyExplicitNonce(Authenticator authenticator, byte contentType, ByteBuffer bb) throws BadPaddingException {
        switch (this.cipherType) {
            case BLOCKS: {
                int tagLen;
                int n = tagLen = authenticator instanceof MAC ? ((MAC)authenticator).MAClen() : 0;
                if (tagLen != 0 && !this.sanityCheck(tagLen, bb.remaining())) {
                    throw new BadPaddingException("ciphertext sanity check failed");
                }
                if (!this.protocolVersion.isTLS11()) break;
                return this.cipher.getBlockSize();
            }
        }
        return 0;
    }

    public int applyExplicitNonce(Authenticator authenticator, byte contentType, byte[] buf, int offset, int cipheredLength) throws BadPaddingException {
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, cipheredLength);
        return this.applyExplicitNonce(authenticator, contentType, bb);
    }

    public byte[] createExplicitNonce(Authenticator authenticator, byte contentType, int fragmentLength) {
        byte[] nonce = new byte[]{};
        switch (this.cipherType) {
            case BLOCKS: {
                if (!this.protocolVersion.isTLS11()) break;
                nonce = new byte[this.cipher.getBlockSize()];
                this.random.nextBytes(nonce);
                break;
            }
        }
        return nonce;
    }

    Boolean isAvailable() {
        return Boolean.TRUE;
    }

    private boolean sanityCheck(int tagLen, int fragmentLen) {
        if (!this.isCBCMode()) {
            return fragmentLen >= tagLen;
        }
        int blockSize = this.cipher.getBlockSize();
        if (fragmentLen % blockSize == 0) {
            int minimal = tagLen + 1;
            int n = minimal = minimal >= blockSize ? minimal : blockSize;
            if (this.protocolVersion.isTLS11()) {
                minimal += blockSize;
            }
            return fragmentLen >= minimal;
        }
        return false;
    }
}

