/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.sun.security.ssl.sec.CipherMode;

public enum CipherBulk {
    B_NULL("NULL", CipherMode.STREAM, 0, 0, 0, 0, true),
    B_SM4_128("SM4/CBC/NoPadding", CipherMode.BLOCKS, 16, 16, 0, true);

    public final String description;
    public final String transformation;
    public final String algorithm;
    public final boolean allowed;
    public final int keySize;
    public final int expandedKeySize;
    public final int ivSize;
    public final int fixedIvSize;
    public final boolean exportable;
    public final CipherMode cipherType;

    private CipherBulk(String transformation, CipherMode cipherType, int keySize, int expandedKeySize, int ivSize, int fixedIvSize, boolean allowed) {
        this.transformation = transformation;
        String[] splits = transformation.split("/");
        this.algorithm = splits[0];
        this.cipherType = cipherType;
        this.description = this.algorithm + "/" + (keySize << 3);
        this.keySize = keySize;
        this.ivSize = ivSize;
        this.fixedIvSize = fixedIvSize;
        this.allowed = allowed;
        this.expandedKeySize = expandedKeySize;
        this.exportable = false;
    }

    private CipherBulk(String transformation, CipherMode cipherType, int keySize, int ivSize, int fixedIvSize, boolean allowed) {
        this(transformation, cipherType, keySize, keySize, ivSize, fixedIvSize, allowed);
    }

    public String toString() {
        return this.description;
    }
}

