/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.pure.IDigest;
import cfca.sadk.tls.pure.impl.SM3Digest;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import java.io.ByteArrayOutputStream;

public final class HandshakeHash {
    private int version = -1;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private IDigest finMD;

    public HandshakeHash(boolean needCertificateVerify) {
    }

    public void update(byte[] b, int offset, int len) {
        if (this.finMD != null) {
            this.finMD.update(b, offset, len);
        }
        this.data.write(b, offset, len);
    }

    public void reset() {
        if (this.version != -1) {
            throw new RuntimeException("reset() can be only be called before protocolDetermined");
        }
        this.data.reset();
    }

    public void protocolDetermined(ProtocolVersion pv) {
        if (this.version == -1 && pv.version != ProtocolVersion.TLS11SM.version) {
            throw new SecurityException("protocolVersion not available->" + pv);
        }
    }

    private static IDigest cloneDigest(IDigest digest) {
        return (IDigest)digest.copy();
    }

    public void setFinishedAlg(String algName) {
        if (algName == null) {
            throw new SecurityException("setFinishedAlg's argument cannot be null");
        }
        if (!HashPRF.SM3.prfHashAlg.equals(algName)) {
            throw new SecurityException("setFinishedAlg's argument not be SM3");
        }
        if (this.finMD == null) {
            this.finMD = (IDigest)new SM3Digest().copy();
        }
        this.finMD.update(this.data.toByteArray());
    }

    public byte[] getAllHandshakeMessages() {
        return this.data.toByteArray();
    }

    public byte[] getFinishedHash() {
        try {
            return HandshakeHash.cloneDigest(this.finMD).digest();
        }
        catch (Exception e) {
            throw new Error("BAD");
        }
    }
}

