/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.IMac;
import cfca.sadk.tls.pure.impl.HMac;
import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.ConnectionKeys;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.sec.MacAlg;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;

public final class MAC
extends Authenticator {
    public static final MAC NULL = new MAC();
    private static final byte[] nullMAC = new byte[0];
    private final MacAlg macAlg;
    private final IMac mac;

    MAC() {
        this.macAlg = MacAlg.NULL;
        this.mac = null;
    }

    MAC(MacAlg macAlg, ProtocolVersion protocolVersion, SecretKey key) throws CryptoException {
        super(protocolVersion);
        if (macAlg != MacAlg.SM3) {
            throw new CryptoException("Unknown Mac " + (Object)((Object)macAlg));
        }
        this.macAlg = macAlg;
        this.mac = new HMac((Digest)new SM3Digest());
        this.mac.init(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MAC newMac(MacAlg macAlg, ProtocolVersion protocolVersion, ConnectionKeys key) throws CryptoException {
        try {
            MAC mAC = new MAC(macAlg, protocolVersion, key.macSecret);
            return mAC;
        }
        finally {
            key.cleanMacKey();
        }
    }

    public int MAClen() {
        return this.macAlg.size;
    }

    public int hashBlockLen() {
        return this.macAlg.hashBlockSize;
    }

    public int minimalPaddingLen() {
        return this.macAlg.minimalPaddingSize;
    }

    public final byte[] compute(byte type, byte[] buf, int offset, int len, boolean isSimulated) {
        byte[] macValue = nullMAC;
        if (this.macAlg.size != 0) {
            macValue = new byte[this.mac.getMacSize()];
            if (!isSimulated) {
                byte[] additional = this.acquireAuthenticationBytes(type, len);
                this.mac.update(additional, 0, additional.length);
            }
            this.mac.update(buf, offset, len);
            this.mac.doFinal(macValue, 0);
        }
        return macValue;
    }

    public final byte[] compute(byte type, ByteBuffer bb, boolean isSimulated) {
        byte[] macValue = nullMAC;
        if (this.macAlg.size != 0) {
            macValue = new byte[this.mac.getMacSize()];
            if (!isSimulated) {
                byte[] additional = this.acquireAuthenticationBytes(type, bb.remaining());
                this.mac.update(additional, 0, additional.length);
            }
            this.mac.update(bb);
            this.mac.doFinal(macValue, 0);
        }
        return macValue;
    }
}

