/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.util;

import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public final class GMSSLConstants {
    public static final boolean debugGmsslVersion = GMSSLConstants.getBooleanProperty("debugGmsslVersion", false);
    public static final boolean debugHandshakerFull = GMSSLConstants.getBooleanProperty("debugHandshakerFull", false);
    public static final int certValidateDeviationSeconds = GMSSLConstants.getIntegerProperty("gmssl.certValidateDeviationSeconds", 300);
    public static final int cacheSizeOfPrivateKeys = GMSSLConstants.getIntegerProperty("gmssl.cacheSizeOfPrivateKeys", 8);
    public static final int cacheSizeOfCerts = GMSSLConstants.getIntegerProperty("gmssl.cacheSizeOfCerts", 64);
    public static final int cacheSizeOfHosts = GMSSLConstants.getIntegerProperty("gmssl.cacheSizeOfHosts", 128);
    public static final int sessionCacheSize = GMSSLConstants.getIntegerProperty("gmssl.sessionCacheSize", 512);
    public static final String clientSSLProtocols = AccessController.doPrivileged(new GetPropertyAction("gmssl.clientProtocols"));
    public static final String hostnamesFile = AccessController.doPrivileged(new GetPropertyAction("gmssl.hostnamesFile", "config/hostnames"));
    public static final boolean checkTLSRevocation = GMSSLConstants.getBooleanProperty("gmssl.checkRevocation", false);
    public static final boolean requireCloseNotify = GMSSLConstants.getBooleanProperty("gmssl.requireCloseNotify", false);
    public static final boolean allowUnsafeRenegotiation = GMSSLConstants.getBooleanProperty("gmssl.allowUnsafeRenegotiation", false);
    public static final boolean allowLegacyHelloMessages = GMSSLConstants.getBooleanProperty("gmssl.allowLegacyHelloMessages", true);
    public static final boolean rejectClientInitiatedRenego = GMSSLConstants.getBooleanProperty("gmssl.rejectClientInitiatedRenegotiation", false);
    public static final boolean enableCBCProtection = GMSSLConstants.getBooleanProperty("gmssl.enableCBCProtection", true);
    public static boolean acceptLargeFragments = GMSSLConstants.getBooleanProperty("gmssl.acceptLargeFragments", false);

    private GMSSLConstants() {
    }

    private static boolean getBooleanProperty(String propName, boolean defaultValue) {
        String value = AccessController.doPrivileged(new GetPropertyAction(propName));
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + propName + " must either be 'true' or 'false'");
    }

    private static int getIntegerProperty(String propName, int defaultValue) {
        String value = AccessController.doPrivileged(new GetPropertyAction(propName));
        int val = defaultValue;
        if (value != null) {
            val = Integer.parseInt(value);
        }
        return val;
    }
}

