/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.util;

import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.util.DeviceConf;
import cfca.sadk.tls.util.Loggings;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLSession;
import sun.security.util.HostnameChecker;

public final class GMSSLHelper {
    public static final String noAlternativeName = "No subject alternative names present";
    private static boolean checkUrlMatchCertIdentity = DeviceConf.isCheckidentity();

    private GMSSLHelper() {
    }

    public static void setCheckUrlMatchCertIdentity(boolean checkUrlMatchCertIdentity) {
        Loggings.ENVIRONMENT.info("checkUrlMatchCertIdentity: {}", (Object)checkUrlMatchCertIdentity);
        GMSSLHelper.checkUrlMatchCertIdentity = checkUrlMatchCertIdentity;
    }

    public static boolean isCheckUrlMatchCertIdentity() {
        return checkUrlMatchCertIdentity;
    }

    public static final X509Certificate[] validate(TLSValidator validator, X509Certificate[] chain, GMAlgorithmConstraints constraints, String authType, boolean isClient) throws CertificateException {
        Collection<X509Certificate> additionals = null;
        return validator.validate(chain, additionals, constraints, authType);
    }

    public static final void checkIdentity(SSLSession session, X509Certificate cert, String protocol, boolean isClient) throws CertificateException {
        if (session != null && checkUrlMatchCertIdentity && !isClient) {
            String peerHost = session.getPeerHost();
            GMSSLHelper.checkClientIdentity(cert, protocol, peerHost);
        }
    }

    private static final void checkClientIdentity(X509Certificate cert, String protocol, String peerHost) throws CertificateException {
        GMSSLHelper.checkIdentity(cert, protocol, peerHost);
    }

    public static final void checkIdentity(X509Certificate cert, String protocol, String hostname) throws CertificateException {
        if (checkUrlMatchCertIdentity) {
            boolean check;
            Debugger.handshaker.debug("checkIdentity->hostname={}", (Object)hostname);
            boolean bl = check = hostname != null && hostname.length() != 0 && cert != null && protocol != null && protocol.length() != 0;
            if (check) {
                if (hostname.length() > 2 && hostname.charAt(0) == '[' && hostname.charAt(hostname.length() - 1) == ']') {
                    hostname = hostname.substring(1, hostname.length() - 1);
                }
                int checkerType = 0;
                if (protocol.equalsIgnoreCase("HTTPS") || protocol.equalsIgnoreCase("TCP")) {
                    checkerType = 1;
                } else if (protocol.equalsIgnoreCase("LDAP") || protocol.equalsIgnoreCase("LDAPS")) {
                    checkerType = 2;
                } else {
                    throw new CertificateException("Unknown identification algorithm: " + protocol);
                }
                HostnameChecker.getInstance((byte)checkerType).match(hostname, cert);
            }
        }
    }

    public static final Set<X509Certificate> getTrustedCerts(KeyStore keystore) {
        Set<X509Certificate> trustedCerts = null;
        try {
            if (keystore != null) {
                trustedCerts = new HashSet<X509Certificate>();
                Enumeration<String> e = keystore.aliases();
                while (e.hasMoreElements()) {
                    Certificate[] certs;
                    String alias = e.nextElement();
                    if (keystore.isCertificateEntry(alias)) {
                        Certificate cert = keystore.getCertificate(alias);
                        if (!(cert instanceof X509Certificate)) continue;
                        trustedCerts.add((X509Certificate)cert);
                        continue;
                    }
                    if (!keystore.isKeyEntry(alias) || (certs = keystore.getCertificateChain(alias)) == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) continue;
                    trustedCerts.add((X509Certificate)certs[0]);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (trustedCerts == null) {
            trustedCerts = Collections.emptySet();
        }
        return trustedCerts;
    }
}

