/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.sadk.tls.sun.security.ssl.manager.CertKeyUsage;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.GMCryptoPrimitive;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public final class GMAlgorithmChecker
extends PKIXCertPathChecker {
    private final GMAlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private PublicKey prevPubKey;

    public GMAlgorithmChecker(GMAlgorithmConstraints constraints) {
        this.prevPubKey = null;
        this.trustedPubKey = null;
        this.constraints = constraints;
    }

    public GMAlgorithmChecker(TrustAnchor anchor, GMAlgorithmConstraints constraints) {
        if (anchor == null) {
            throw new IllegalArgumentException("The trust anchor cannot be null");
        }
        this.trustedPubKey = anchor.getTrustedCert() != null ? anchor.getTrustedCert().getPublicKey() : anchor.getCAPublicKey();
        this.prevPubKey = this.trustedPubKey;
        this.constraints = constraints;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.prevPubKey = this.trustedPubKey;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        if (this.constraints == null || !(cert instanceof X509Certificate)) {
            return;
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        PublicKey currPubKey = x509Cert.getPublicKey();
        CertKeyUsage keyUsage = CertKeyUsage.check(x509Cert.getKeyUsage());
        if (keyUsage.enabled()) {
            EnumSet<GMCryptoPrimitive> primitives = EnumSet.noneOf(GMCryptoPrimitive.class);
            if (keyUsage.enabledSigning()) {
                primitives.add(GMCryptoPrimitive.SIGNATURE);
            }
            if (keyUsage.keyEncipherment()) {
                primitives.add(GMCryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (keyUsage.dataEncipherment()) {
                primitives.add(GMCryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (keyUsage.keyAgreement()) {
                primitives.add(GMCryptoPrimitive.KEY_AGREEMENT);
            }
            if (!primitives.isEmpty() && !this.constraints.permits(primitives, currPubKey)) {
                throw new CertPathValidatorException("algorithm constraints check failed", null, null, -1);
            }
        }
        this.prevPubKey = currPubKey;
    }

    void trySetTrustAnchor(TrustAnchor anchor) {
        if (this.prevPubKey == null) {
            if (anchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            this.prevPubKey = anchor.getTrustedCert() != null ? anchor.getTrustedCert().getPublicKey() : anchor.getCAPublicKey();
        }
    }

    static void check(PublicKey key, X509CRL crl) throws CertPathValidatorException {
    }
}

