package com.youqian.uid.event;

import lombok.Data;

import java.io.Serializable;

@Data
public class RedundantEvent implements Serializable {
    String tableName;
    KeyValue primaryField;
    KeyValue redundantField;

    RedundantEvent(){}

    public RedundantEvent(String tableName, KeyValue primaryField, KeyValue redundantField) {
        this.redundantField = redundantField;
        this.tableName = tableName;
        this.primaryField = primaryField;
    }

    @Data
    public static class KeyValue{
        private String key;
        private Object value;

        public KeyValue() {
        }
    }

}
