package com.youqian.uid.mq.product;

import com.alibaba.fastjson.JSON;
import com.youqian.uid.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.util.Objects;

/**
 * Created by hong
 * time 2020/5/8.
 */
@Slf4j
@Component
public class MqProductComponent {
    @Autowired
    private DefaultMQProducer defaultMQProducer;

    public Boolean send(Object dto,String topic ,String tag){
        boolean result = false;
        if (Objects.isNull(dto)) {
            return Boolean.FALSE;
        }
        String body;
        if (dto instanceof String) {
            body = (String) dto;
        } else {
            body = JsonUtils.toJsonString(dto);
        }
        try {
            Message    message = new Message(topic, tag, body.getBytes("UTF-8"));
            SendResult send    = defaultMQProducer.send(message);
            if (Objects.nonNull(send) && SendStatus.SEND_OK.equals(send.getSendStatus())) {
                result = true;
            } else {
                log.error("send mq error, send={}, body={}", JSON.toJSONString(send), body);
            }
        } catch (MQClientException | RemotingException | MQBrokerException e) {
            log.error("发送消息失败：{}",e);
        } catch (InterruptedException e){
            Thread.currentThread().interrupt();
        } catch (UnsupportedEncodingException e) {
            log.error("系统不支持utf-8");
        }
        return result;
    }
}
