package com.youqian.uid.plugin;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.youqian.uid.UidGenerator;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

/**
 * Created by hong
 * time 2020/3/29.
 */
@Configuration
@ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, UidGenerator.class})
@ImportResource(locations = { "classpath:uid/cached-uid-spring.xml" })
public class MybatisPluginConfiguration{

    private static RedundantInterceptor redundantInterceptor;

    private static Object lock = new Object();


    /**
     * 插件实体
     */
    @Bean
    public static AutoIdInterceptor autoIdInterceptor(UidGenerator uidGenerator) {
        return new AutoIdInterceptor(uidGenerator);
    }

    public static RedundantInterceptor initRedundantInterceptor(){
        if(redundantInterceptor == null){
            synchronized (lock){
                if(redundantInterceptor == null) {
                    redundantInterceptor = new RedundantInterceptor();
                }
            }
        }
        return redundantInterceptor;
    }


    @Bean
    public static SpecifiedBeanPostProcessor<SqlSessionFactoryBean> mybatisAddPluginPostProcessorConfigurer(UidGenerator uidGenerator){

        return new SpecifiedBeanPostProcessor<SqlSessionFactoryBean>() {

            @Override
            public int getOrder() {
                return -1;
            }

            @Override
            public Class<SqlSessionFactoryBean> getBeanType() {
                return SqlSessionFactoryBean.class;
            }

            @Override
            public Object postProcessBeforeInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                /**
                 * 添加插件信息(因为插件采用责任链模式所有可以有多个，所以采用数组
                 */
                Interceptor[] interceptors = new Interceptor[]{MybatisPluginConfiguration.autoIdInterceptor(uidGenerator), MybatisPluginConfiguration.initRedundantInterceptor()};
                bean.setPlugins(interceptors);
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                return bean;
            }
        };

    }
}
