package com.youqian.uid.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonTokenId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author tengtuox
 * @date 19-1-14
 */
public class BigDecimalDeserializer extends NumberDeserializers.BigDecimalDeserializer {

    @Override
    public BigDecimal deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        int currentTokenId = p.getCurrentTokenId();
        if (!Objects.equals(JsonTokenId.ID_STRING, currentTokenId)) {
            return super.deserialize(p, ctxt);
        }

        String text = p.getText().trim();
        if (_isEmptyOrTextualNull(text)) {
            _verifyNullForScalarCoercion(ctxt, text);
            return getNullValue(ctxt);
        }

        _verifyStringForScalarCoercion(ctxt, text);
        try {
            // 去除,号
            text = text.replaceAll(",", "");
            return new BigDecimal(text);
        } catch (IllegalArgumentException iae) {
            // ignore
        }
        return (BigDecimal) ctxt.handleWeirdStringValue(_valueClass, text,
                "not a valid representation");
    }
}
