package com.youqian.api.params.dunningbill;

import com.youqian.api.annotation.AutoId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 订单与回款单批量关系绑定参数
 * Created by hong
 * time 2020/4/17.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrderDunningBillBatchInsertParam {

    /**
     * 回款单id
     * not null default = null
     */
    private Long       dunningBillId;

    /**
     * 订单id
     */
    private Long       orderId;

    /**
     * 订单回款单关联id(前端不需要)
     */
    @AutoId
    private Long       orderDunningBillRId;
}
