package com.youqian.api.params.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

@Data
public class ConfirmEmployeeParam implements Serializable {

    @ApiModelProperty(value = "商户ID")
    private Long merchantId;

    @NotBlank(message = "请输入成立时间")
    @ApiModelProperty(value = "成立日期")
    private String establishDate;

    @NotBlank(message = "请输入注册资本")
    @ApiModelProperty(value = "注册资本")
    private String registeredAssets;

    @NotBlank(message = "请输入企业名称")
    @ApiModelProperty(value = "企业名称")
    private String name;

    @NotBlank(message = "请输入法人名称")
    @Size(max = 10, min = 2, message = "法人名长度要在2-10之间")
    @ApiModelProperty(value = "法人名称")
    private String legalPerson;

    @NotBlank(message = "请输入法人身份证")
    @ApiModelProperty(value = "法人身份证")
    private String legalPersonIdCard;

    @ApiModelProperty(value = "营业执照文件ID（识别营业执照后返回")
    private String licenseFileId;

    @NotBlank(message = "请输入社会统一信用代码")
    @ApiModelProperty(value = "社会统一信用代码")
    private String regCode;

    @ApiModelProperty(value = "正面文件ID(身份证识别返回-正面-人像面)")
    private String frontFileId;

    @ApiModelProperty(value = "反面文件ID(身份证识别返回-反面-国徽面)")
    private String backFileId;

    @ApiModelProperty(value = "企业类型:1-企业,0-个体工商户")
    private Integer type;
}
