package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.merchant.MerchantStoreDto;
import com.youqian.api.request.FollowRequest;
import com.youqian.api.response.FollowResult;

/**
 * @author chenhang
 * @date 2020/3/28
 * @description
 */
@AdvancedFeignClient
public interface RemoteMerchantService {

    /**
     * 查询商户与改用户的关联
     * @param followRequest 用户Id/商户Id
     * @return
     */
    FollowResult selectMerchantByUserId(FollowRequest followRequest);

    /**
     * 根据商户id获取商户店铺
     * @param merchantId 商户id
     */
    MerchantStoreDto getStoreByMerchantId(Long merchantId);
}
