package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderPageRequest extends PageRequest implements Serializable {

    private static final long serialVersionUID = 5570968457893120011L;

    @ApiModelProperty("订单状态")
    private Byte orderStatus;

    @ApiModelProperty("客户ID/等同于customerId")
    private Long clientId;

    @ApiModelProperty("用户ID（前端忽略）")
    private Long createUserId;

    @ApiModelProperty("商户ID（前端忽略）")
    private Long merchantId;

    @ApiModelProperty("发货状态（前端忽略）")
    private Byte deliverGoods;

    @ApiModelProperty("收款状态（前端忽略）")
    private List<Byte> moneyReceiveType;
}
