package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description 分页请求
 */
@Data
public class PageRequest implements Serializable {

    private static final long serialVersionUID = -5791541811801984408L;

    @ApiModelProperty(value = "页码,从1开始", required = true)
    private Integer pageNo = 1;

    @ApiModelProperty(value = "页大小", required = true)
    private Integer pageSize = 10;

    @ApiModelProperty("前端忽略")
    public Integer startLimit;

    public PageRequest() {
        rebuildStartLimit();
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
        rebuildStartLimit();
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        rebuildStartLimit();
    }

    private void rebuildStartLimit() {
        startLimit = ( pageNo - 1 ) * pageSize;
    }

}