package com.youqian.api.response;

import com.youqian.api.dto.follow.FollowListDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class UserFollowListResult implements Serializable {
    /**
     * 店铺Id
     */
    private String id;
    /**
     * 	店铺头像链接
     */
    private String logoUrl;
    /**
     * 	店铺名
     */
    private String shopName;
    /**
     * 	直播状态，0-未播，1-结束 2-未开播 3.直播中
     * @see com.jiamai.live.enums.EnumRoomStatus
     */
    private Byte liveStatus;
    /**
     * 	直播状态文案
     */
    private String liveStatusName;
    /**
     * 	直播摘要图
     */
    private String livePicUrl;
    /**
     * 店铺图片信息
     */
    private FollowListDto shopImage;
    /**
     * 商户ID
     */
    private Long merchantId;
}
