package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
public class OrderDetail implements Serializable {

    @ApiModelProperty("订单编号")
    private Long orderId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("订单创建人")
    private Long createUserId;

    @ApiModelProperty("开单人姓名")
    private String createUserName;

    @ApiModelProperty("开单人账号")
    private String createAccount;

    @ApiModelProperty("客户ID")
    private Long customerId;

    @ApiModelProperty("客户主体ID")
    private Long customerSignEntityId;

    @ApiModelProperty("客户UserId")
    private Long customerUserId;

    @ApiModelProperty("客户手机号")
    private String customerMobile;

    @ApiModelProperty("客户经办人名称")
    private String customerName;

    @ApiModelProperty("客户企业名称")
    private String customerEnterpriseName;

    @ApiModelProperty("商品总额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal goodsPrice;

    @ApiModelProperty("（原价）订单总额=商品总额+运费+税费等等")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal originOrderPrice;

    @ApiModelProperty("订单总额折后价")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal orderPrice;

    @ApiModelProperty("优惠的金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal reducePrice;

    @ApiModelProperty("已收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal receivePrice;

    @ApiModelProperty("待收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal restPrice;

    @ApiModelProperty("订单状态")
    private Byte orderStatus;

    @ApiModelProperty("订单状态文字")
    private String orderStatusText;

    @ApiModelProperty("发货状态")
    private Byte deliverGoods;

    @ApiModelProperty("收款状态")
    private Byte moneyReceiveType;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("订单更新时间")
    private Date gmtModified;

    @ApiModelProperty("订单更新时间文本")
    private String gmtModifiedText;

    @ApiModelProperty("是否是买家")
    private Byte buyer;

    /**======OrderExt=====*/
    @ApiModelProperty("运费")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal transportFee;

    @ApiModelProperty("运输方式， 1-卖家送货/2-买家自提")
    private Byte transType;

    @ApiModelProperty("收货人名称")
    private String receiverName;

    @ApiModelProperty("收货人手机号码")
    private String receiverMobile;

    @ApiModelProperty("收货地址")
    private String receiverAddress;

    @ApiModelProperty("提货人")
    private String deliveryName;

    @ApiModelProperty("提货人手机号码")
    private String deliveryMobile;

    @ApiModelProperty("提货地址")
    private String deliveryAddress;

    /**=====Goods=====*/
    @ApiModelProperty("商品详情")
    private List<OrderItemDetail> goodsList;

    /**=====Button====*/
    @ApiModelProperty("是否有发起合同按钮")
    private Boolean createContractButton = Boolean.FALSE;

    @ApiModelProperty("是否有录入收款按钮")
    private Boolean moneyBackButton = Boolean.FALSE;

    @ApiModelProperty("是否有我发货了按钮")
    private Boolean deliverGoodsButton = Boolean.FALSE;

    @ApiModelProperty("是否有发送给客户按钮")
    private Boolean sendCustomerButton = Boolean.FALSE;

    @ApiModelProperty("是否有购销合同按钮")
    private Boolean contractButton = Boolean.FALSE;

    @ApiModelProperty("是否有收款记录按钮")
    private Boolean moneyBackHisButton = Boolean.FALSE;

    @ApiModelProperty("是否有确认订单按钮")
    private Boolean confirmButton = Boolean.FALSE;

    @ApiModelProperty("是否有取消订单按钮")
    private Boolean cancelButton = Boolean.FALSE;

    @ApiModelProperty("是否有返回首页按钮")
    private Boolean returnTopButton = Boolean.FALSE;

}
