package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
public class OrderItemResult implements Serializable {

    @ApiModelProperty("skuId")
    private Long skuId;

    @ApiModelProperty("skuName")
    private String skuName;

    @ApiModelProperty("数量")
    private Integer num;

    @ApiModelProperty("单价")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal price;

    @ApiModelProperty("总价格")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;
}
